/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.doa;

import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.Ability;

public class DoorDoorAbility
extends Ability {
    public static final DoorDoorAbility INSTANCE = new DoorDoorAbility();

    public DoorDoorAbility() {
        super("Door Door", AbilityHelper.getDevilFruitCategory());
        this.setDescription("By making a door, the user transports to the other side of any surface");
        this.setMaxCooldown(5.0);
        this.onUseEvent = this::onUseEvent;
    }

    private boolean onUseEvent(PlayerEntity player) {
        BlockRayTraceResult hitBlock = WyHelper.rayTraceBlocks((Entity)player, 16.0);
        if (Math.sqrt(player.func_195048_a(hitBlock.func_216347_e())) > 2.5) {
            return false;
        }
        Vec3d dir = WyHelper.propulsion((LivingEntity)player, 2.0, 2.0);
        int x = (int)Math.floor(dir.field_72450_a);
        int z = (int)Math.floor(dir.field_72449_c);
        if (dir.field_72450_a > -0.3 && dir.field_72450_a < 0.0 || dir.field_72450_a > 0.0 && dir.field_72450_a < 0.3) {
            x = 0;
        }
        if (dir.field_72449_c > -0.3 && dir.field_72449_c < 0.0 || dir.field_72449_c > 0.0 && dir.field_72449_c < 0.3) {
            z = 0;
        }
        Vec3i iDir = new Vec3i((double)x, dir.field_72448_b, (double)z);
        BlockPos pos = player.func_180425_c().func_177971_a(iDir);
        boolean firstSolid = false;
        int airBlocks = 0;
        for (int i = 0; i < 40; ++i) {
            if (player.field_70170_p.func_180495_p(pos) == Blocks.field_150350_a.func_176223_P() && (firstSolid || airBlocks > 1)) {
                player.func_70634_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
                break;
            }
            dir = WyHelper.propulsion((LivingEntity)player, 2.0, 2.0);
            if (dir.field_72450_a > -0.3 && dir.field_72450_a < 0.0 || dir.field_72450_a > 0.0 && dir.field_72450_a < 0.3) {
                x = 0;
            }
            if (dir.field_72449_c > -0.3 && dir.field_72449_c < 0.0 || dir.field_72449_c > 0.0 && dir.field_72449_c < 0.3) {
                z = 0;
            }
            if (player.field_70170_p.func_180495_p(pos = pos.func_177971_a(iDir = new Vec3i((double)x, dir.field_72448_b, (double)z))).func_200132_m()) {
                firstSolid = true;
            }
            if (player.field_70170_p.func_180495_p(pos) != Blocks.field_150350_a.func_176223_P()) continue;
            ++airBlocks;
        }
        player.field_70170_p.func_184133_a(null, player.func_180425_c(), ModSounds.DOA_IN_SFX, SoundCategory.PLAYERS, 1.0f, 1.0f);
        return true;
    }
}

