/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.electro;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import xyz.pixelatedw.mineminenomi.abilities.electro.EleclawAbility;
import xyz.pixelatedw.mineminenomi.abilities.electro.SulongAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityPool;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.FactionHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.goro.LightningBallEntity;
import xyz.pixelatedw.mineminenomi.entities.projectiles.goro.LightningEntity;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.particles.effects.electro.ElectricalTempesta2ParticleEffect;
import xyz.pixelatedw.mineminenomi.particles.effects.electro.ElectroChargingParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.ChargeableAbility;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.AbilityDataCapability;

public class ElectricalTempestaAbility
extends ChargeableAbility {
    public static final ElectricalTempestaAbility INSTANCE = new ElectricalTempestaAbility();
    private static final ElectroChargingParticleEffect PARTICLES1 = new ElectroChargingParticleEffect();
    private static final ElectricalTempesta2ParticleEffect PARTICLES2 = new ElectricalTempesta2ParticleEffect();
    private static final int COOLDOWN = 12;
    private static final int CHARGE_TIME = 4;
    private LightningBallEntity ballEntity = null;

    public ElectricalTempestaAbility() {
        super("Electrical Tempesta", AbilityHelper.getRacialCategory());
        this.setMaxCooldown(12.0);
        this.setMaxChargeTime(4.0);
        this.setDescription("The user releases a charge of energy that deals damage to nearby enemies");
        this.setInPool(AbilityPool.MINK_ELECTRO);
        this.onStartChargingEvent = this::onStartChargingEvent;
        this.duringChargingEvent = this::duringChargingEvent;
        this.onEndChargingEvent = this::onEndChargingEvent;
    }

    private boolean onStartChargingEvent(PlayerEntity player) {
        boolean eleclawEnabled;
        EleclawAbility eleclawAbility = AbilityDataCapability.get((LivingEntity)player).getEquippedAbility(EleclawAbility.INSTANCE);
        boolean bl = eleclawEnabled = eleclawAbility != null && eleclawAbility.isContinuous();
        if (!eleclawEnabled) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_NEED_ELECLAW, new Object[0]));
            return false;
        }
        SulongAbility sulongAbility = AbilityDataCapability.get((LivingEntity)player).getEquippedAbility(SulongAbility.INSTANCE);
        boolean sulongEnabled = sulongAbility != null && sulongAbility.isContinuous();
        this.setMaxChargeTime(sulongEnabled ? 2.6666667461395264 : 4.0);
        this.setMaxCooldown(sulongEnabled ? 6.0 : 12.0);
        return true;
    }

    private void duringChargingEvent(PlayerEntity player, int chargeTime) {
        player.func_195064_c(new EffectInstance(ModEffects.MOVEMENT_BLOCKED, 4, 1, false, false));
        if (chargeTime > 10) {
            PARTICLES1.spawn(player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), 0.0, 0.0, 0.0);
        }
        if (this.ballEntity == null) {
            LightningBallEntity ball = new LightningBallEntity((Entity)player, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), player.field_70177_z, player.field_70125_A);
            player.field_70170_p.func_217376_c((Entity)ball);
            this.ballEntity = ball;
        } else {
            float distance = 0.5f;
            Vec3d lookVec = player.func_70040_Z();
            Vec3d pos = new Vec3d(player.func_226277_ct_() + lookVec.field_72450_a * (double)distance, player.func_226278_cu_() + (double)player.func_70047_e() * 0.85 + lookVec.field_72448_b * (double)distance, player.func_226281_cx_() + lookVec.field_72449_c * (double)distance);
            float percentage = 1.0f - (float)this.getChargeTime() / (float)this.getMaxChargeTime();
            this.ballEntity.setSize(percentage * 0.1f);
            this.ballEntity.setLightningLength(2.0f);
            this.ballEntity.func_70080_a(pos.func_82615_a(), pos.func_82617_b(), pos.func_82616_c(), player.field_70177_z, player.field_70125_A);
        }
    }

    private boolean onEndChargingEvent(PlayerEntity player) {
        EleclawAbility eleclawAbility;
        boolean eleclawEnabled;
        if (this.ballEntity != null) {
            this.ballEntity.func_70106_y();
            this.ballEntity = null;
        }
        boolean bl = eleclawEnabled = (eleclawAbility = AbilityDataCapability.get((LivingEntity)player).getEquippedAbility(EleclawAbility.INSTANCE)) != null && eleclawAbility.isContinuous();
        if (eleclawEnabled) {
            float damage = 12.0f * eleclawAbility.getElectricPowerPercentage(player);
            int range = (int)(8.0f * eleclawAbility.getElectricPowerPercentage(player));
            for (int i = 0; i < 3; ++i) {
                PARTICLES2.spawn(player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), 0.0, 0.0, 0.0);
            }
            List<LivingEntity> list = WyHelper.getEntitiesNearSphere(player.func_180425_c(), player.field_70170_p, range, FactionHelper.getOutsideGroupPredicate((LivingEntity)player), LivingEntity.class);
            list.remove(player);
            list.forEach(entity -> {
                boolean hit = entity.func_70097_a(ModDamageSource.LIGHTNING_BOLT.causeEntityDamageFromSource((Entity)player), damage);
                if (hit) {
                    Vec3d speed = entity.func_70676_i(1.0f).func_216372_d(-1.0, -1.0, -1.0).func_216372_d(3.0, 0.0, 3.0);
                    entity.func_213293_j(speed.field_72450_a, 1.0, speed.field_72449_c);
                    entity.field_70133_I = true;
                }
            });
            int amount = 32;
            for (int j = 0; j < amount; ++j) {
                float boltSize = (float)WyHelper.randomWithRange(3, range);
                LightningEntity bolt = new LightningEntity((Entity)player, player.func_226277_ct_(), player.func_226278_cu_() + 0.75, player.func_226281_cx_(), (float)WyHelper.randomWithRange(0, 360), (float)WyHelper.randomWithRange(0, 5), boltSize, 8.0f);
                bolt.setAngle(60);
                bolt.setAliveTicks(20);
                bolt.setDamage(0.0f);
                bolt.setExplosion(0, false);
                bolt.setSize(boltSize / 600.0f);
                bolt.setBranches((int)WyHelper.randomWithRange(1, 3));
                bolt.setSegments((int)((double)boltSize * 0.6));
                bolt.disableLightningMimic();
                player.field_70170_p.func_217376_c((Entity)bolt);
            }
            player.func_71020_j(2.0f);
            eleclawAbility.reduceUsage(player, 2);
        }
        return true;
    }
}

