/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.electro;

import java.util.UUID;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.wypi.abilities.ContinuousAbility;
import xyz.pixelatedw.mineminenomi.wypi.abilities.IParallelContinuousAbility;

public class SulongAbility
extends ContinuousAbility
implements IParallelContinuousAbility {
    public static final SulongAbility INSTANCE = new SulongAbility();
    private static final AttributeModifier SPEED_MODIFIER = new AttributeModifier(UUID.fromString("e158d542-5644-4921-9d5f-895f0b0a164c"), "Sulong Speed Modifier", 1.5, AttributeModifier.Operation.MULTIPLY_BASE).func_111168_a(false);
    private static final AttributeModifier STRENGTH_MODIFIER = new AttributeModifier(UUID.fromString("00bd47ca-63b1-4040-b942-d9857231c9da"), "Sulong Damage Addition", 7.0, AttributeModifier.Operation.ADDITION).func_111168_a(false);
    private static final AttributeModifier JUMP_MODIFIER = new AttributeModifier(UUID.fromString("00bd47ca-63b1-4040-b942-d9857231c9da"), "Sulong Damage Addition", 8.0, AttributeModifier.Operation.ADDITION).func_111168_a(false);
    private static final AttributeModifier FALL_RESISTANCE = new AttributeModifier(UUID.fromString("00bd47ca-63b1-4040-b942-d9857231c9da"), "Sulong Damage Addition", 8.0, AttributeModifier.Operation.ADDITION).func_111168_a(false);
    private static final AttributeModifier STEP_HEIGHT = new AttributeModifier(UUID.fromString("eab680cd-a6dc-438a-99d8-46f9eb53a950"), "Sulong Step Height", 1.0, AttributeModifier.Operation.ADDITION).func_111168_a(false);

    public SulongAbility() {
        super("Sulong Form", AbilityHelper.getRacialCategory());
        this.setThreshold(300.0);
        this.setDescription("The user reveals their true power during the full moon, enhancing their physical and electrical power");
        this.onStartContinuityEvent = this::onStartContinuityEvent;
        this.duringContinuityEvent = this::duringContinuityEvent;
        this.onEndContinuityEvent = this::onEndContinuityEvent;
    }

    private void duringContinuityEvent(PlayerEntity player, int i) {
        boolean sulongCheck = this.canTransform(player.field_70170_p, player);
        if (!sulongCheck) {
            this.stopContinuity(player);
        }
    }

    private boolean onStartContinuityEvent(PlayerEntity player) {
        boolean sulongCheck = this.canTransform(player.field_70170_p, player);
        if (sulongCheck) {
            player.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111121_a(SPEED_MODIFIER);
            player.func_110148_a(SharedMonsterAttributes.field_188790_f).func_111121_a(SPEED_MODIFIER);
            player.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111121_a(STRENGTH_MODIFIER);
            player.func_110148_a(ModAttributes.JUMP_HEIGHT).func_111121_a(JUMP_MODIFIER);
            player.func_110148_a(ModAttributes.FALL_RESISTANCE).func_111121_a(FALL_RESISTANCE);
            player.func_110148_a(ModAttributes.STEP_HEIGHT).func_111121_a(STEP_HEIGHT);
            player.func_71020_j(5.0f);
        } else {
            player.func_145747_a((ITextComponent)new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_NEED_MOON, new Object[0]));
        }
        return sulongCheck;
    }

    private boolean onEndContinuityEvent(PlayerEntity player) {
        player.func_195064_c(new EffectInstance(Effects.field_76438_s, 400, 1));
        player.func_195064_c(new EffectInstance(Effects.field_76419_f, 300, 1));
        player.func_195064_c(new EffectInstance(Effects.field_76421_d, 300, 1));
        player.func_195064_c(new EffectInstance(Effects.field_76437_t, 300, 1));
        player.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111124_b(SPEED_MODIFIER);
        player.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111124_b(SPEED_MODIFIER);
        player.func_110148_a(SharedMonsterAttributes.field_188790_f).func_111124_b(SPEED_MODIFIER);
        player.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111124_b(STRENGTH_MODIFIER);
        player.func_110148_a(ModAttributes.JUMP_HEIGHT).func_111124_b(JUMP_MODIFIER);
        player.func_110148_a(ModAttributes.FALL_RESISTANCE).func_111124_b(FALL_RESISTANCE);
        player.func_110148_a(ModAttributes.STEP_HEIGHT).func_111124_b(STEP_HEIGHT);
        player.func_71020_j(10.0f);
        this.setMaxCooldown((float)this.continueTime / 15.0f);
        return true;
    }

    private boolean canTransform(World world, PlayerEntity player) {
        return world.func_201675_m().func_76559_b(world.func_72820_D()) == 0 && !world.func_72896_J() && world.func_201675_m().func_186058_p() == DimensionType.field_223227_a_ && world.func_226690_K_() && world.func_226660_f_(player.func_180425_c().func_177963_a(0.0, 1.2, 0.0));
    }
}

