/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.gomu;

import java.util.UUID;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import xyz.pixelatedw.mineminenomi.abilities.haki.BusoshokuHakiFullBodyHardeningAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.HakiHelper;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.wypi.abilities.ContinuousAbility;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.AbilityDataCapability;

public class GearFourthAbility
extends ContinuousAbility {
    public static final GearFourthAbility INSTANCE = new GearFourthAbility();
    private static final AttributeModifier MODIFIER = new AttributeModifier(UUID.fromString("e158d542-5644-4921-9d5f-895f0b0a164c"), "Gear Fourth Modifier", 5.0, AttributeModifier.Operation.ADDITION).func_111168_a(false);
    private static final AttributeModifier STRENGTH_MODIFIER = new AttributeModifier(UUID.fromString("00bd47ca-63b1-4040-b942-d9857231c9da"), "Gear Attack Damage Multiplier", 15.0, AttributeModifier.Operation.ADDITION).func_111168_a(false);
    private static final AttributeModifier DAMAGE_REDUCTION_MODIFIER = new AttributeModifier(UUID.fromString("1972705a-a0b6-4e66-8a4b-f64b0232b6f2"), "Gear Resistance Damage Multiplier", 0.5, AttributeModifier.Operation.ADDITION).func_111168_a(false);
    public float speed = 0.0f;

    public GearFourthAbility() {
        super("Gear Fourth", AbilityHelper.getDevilFruitCategory());
        this.setThreshold(30.0);
        this.setDescription("The user inflates their muscle structure to tremendously increase the power of their attacks and also allows flight");
        this.onStartContinuityEvent = this::onStartContinuityEvent;
        this.duringContinuityEvent = this::duringContinuity;
        this.onEndContinuityEvent = this::onEndContinuityEvent;
    }

    private boolean onStartContinuityEvent(PlayerEntity player) {
        boolean hakiCheck;
        BusoshokuHakiFullBodyHardeningAbility ability = AbilityDataCapability.get((LivingEntity)player).getEquippedAbility(BusoshokuHakiFullBodyHardeningAbility.INSTANCE);
        boolean bl = hakiCheck = ability != null && ability.isContinuous();
        if (!hakiCheck) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_NEED_HAKI, new Object[0]));
        } else {
            player.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111121_a(MODIFIER);
            player.func_110148_a(SharedMonsterAttributes.field_189429_h).func_111121_a(MODIFIER);
            player.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111121_a(STRENGTH_MODIFIER);
            player.func_110148_a(ModAttributes.DAMAGE_REDUCTION).func_111121_a(DAMAGE_REDUCTION_MODIFIER);
        }
        return hakiCheck;
    }

    private void duringContinuity(PlayerEntity player, int passiveTimer) {
        BusoshokuHakiFullBodyHardeningAbility ability = AbilityDataCapability.get((LivingEntity)player).getEquippedAbility(BusoshokuHakiFullBodyHardeningAbility.INSTANCE);
        boolean hakiCheck = ability != null && ability.isContinuous();
        boolean isOnMaxOveruse = HakiHelper.checkForHakiOveruse(player, 2);
        if (isOnMaxOveruse || !hakiCheck || AbilityHelper.isNearbyKairoseki(player)) {
            this.stopContinuity(player);
        }
    }

    private boolean onEndContinuityEvent(PlayerEntity player) {
        BusoshokuHakiFullBodyHardeningAbility ability;
        boolean hakiCheck;
        if (this.continueTime > this.getThreshold() / 10) {
            player.func_195064_c(new EffectInstance(Effects.field_76438_s, 600, 3, true, true));
            player.func_195064_c(new EffectInstance(Effects.field_76421_d, 600, 2, true, true));
            player.func_195064_c(new EffectInstance(Effects.field_76437_t, 600, 2, true, true));
            player.func_195064_c(new EffectInstance(ModEffects.ABILITY_OFF, 400, 1, true, true));
        }
        boolean bl = hakiCheck = (ability = AbilityDataCapability.get((LivingEntity)player).getEquippedAbility(BusoshokuHakiFullBodyHardeningAbility.INSTANCE)) != null && ability.isContinuous();
        if (hakiCheck) {
            ability.stopContinuity(player);
        }
        player.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111124_b(MODIFIER);
        player.func_110148_a(SharedMonsterAttributes.field_189429_h).func_111124_b(MODIFIER);
        player.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111124_b(STRENGTH_MODIFIER);
        player.func_110148_a(ModAttributes.DAMAGE_REDUCTION).func_111124_b(DAMAGE_REDUCTION_MODIFIER);
        int cooldown = 5 + (int)Math.round((double)this.continueTime / 20.0);
        this.setMaxCooldown(cooldown);
        return true;
    }
}

