/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.gomu;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SAnimateHandPacket;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.GomuHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.gomu.GomuGomuNoCulverinProjectile;
import xyz.pixelatedw.mineminenomi.entities.projectiles.gomu.GomuGomuNoElephantGunProjectile;
import xyz.pixelatedw.mineminenomi.entities.projectiles.gomu.GomuGomuNoJetPistolProjectile;
import xyz.pixelatedw.mineminenomi.entities.projectiles.gomu.GomuGomuNoPistolProjectile;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.wypi.abilities.Ability;
import xyz.pixelatedw.mineminenomi.wypi.abilities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.IAbilityData;

public class GomuGomuNoPistolAbility
extends Ability {
    public static final GomuGomuNoPistolAbility INSTANCE = new GomuGomuNoPistolAbility();
    private Mode mode = Mode.NORMAL;

    public GomuGomuNoPistolAbility() {
        super("Gomu Gomu no Pistol", AbilityHelper.getDevilFruitCategory());
        this.setDescription("The user stretches their arm to hit the opponent");
        this.setMaxCooldown(1.5);
        this.onUseEvent = this::onUseEvent;
    }

    private boolean onUseEvent(PlayerEntity player) {
        IAbilityData props = AbilityDataCapability.get((LivingEntity)player);
        AbilityProjectileEntity projectile = null;
        float speed = 2.0f;
        ((ServerWorld)player.field_70170_p).func_72863_F().func_217216_a((Entity)player, (IPacket)new SAnimateHandPacket((Entity)player, 0));
        if (GomuHelper.hasGearFourthActive(props)) {
            projectile = new GomuGomuNoCulverinProjectile(player.field_70170_p, (LivingEntity)player);
            projectile.setCollisionSize(2.5);
            speed = 1.8f;
            if (this.mode != Mode.GEAR_FOURTH) {
                this.setMaxCooldown(4.0);
                this.setDisplayName("Gomu Gomu no Culverin");
                this.mode = Mode.GEAR_FOURTH;
            }
        } else if (GomuHelper.hasGearThirdActive(props)) {
            projectile = new GomuGomuNoElephantGunProjectile(player.field_70170_p, (LivingEntity)player);
            projectile.setCollisionSize(2.5);
            speed = 1.8f;
            if (this.mode != Mode.GEAR_THIRD) {
                this.setMaxCooldown(6.0);
                this.setDisplayName("Gomu Gomu no Elephant Gun");
                this.mode = Mode.GEAR_THIRD;
            }
        } else if (GomuHelper.hasGearSecondActive(props)) {
            projectile = new GomuGomuNoJetPistolProjectile(player.field_70170_p, (LivingEntity)player);
            speed = 2.5f;
            if (this.mode != Mode.GEAR_SECOND) {
                this.setMaxCooldown(1.0);
                this.setDisplayName("Gomu Gomu no Jet Pistol");
                this.mode = Mode.GEAR_SECOND;
            }
        } else {
            projectile = new GomuGomuNoPistolProjectile(player.field_70170_p, (LivingEntity)player);
            if (this.mode != Mode.NORMAL) {
                this.setMaxCooldown(1.5);
                this.setDisplayName("Gomu Gomu no Pistol");
                this.mode = Mode.NORMAL;
            }
        }
        player.field_70170_p.func_217376_c((Entity)projectile);
        projectile.func_184538_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, speed, 1.0f);
        player.field_70170_p.func_184133_a(null, player.func_180425_c(), ModSounds.GOMU_SFX, SoundCategory.PLAYERS, 0.8f, (float)MathHelper.func_151237_a((double)(player.func_70681_au().nextDouble() * 2.0), (double)1.0, (double)1.3f));
        return true;
    }

    public static enum Mode {
        NORMAL,
        GEAR_SECOND,
        GEAR_THIRD,
        GEAR_FOURTH;

    }
}

