/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.goro;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.RayTraceResult;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.goro.RaigoProjectile;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.particles.effects.goro.RaigoParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.Ability;

public class RaigoAbility
extends Ability {
    public static final Ability INSTANCE = new RaigoAbility();
    private static final ParticleEffect PARTICLES = new RaigoParticleEffect();
    private double posX;
    private double posY;
    private double posZ;

    public RaigoAbility() {
        super("Raigo", AbilityHelper.getDevilFruitCategory());
        this.setMaxCooldown(40.0);
        this.setDescription("Creates a huge cloud filled with electricity, which drops a massive lighting ball onto enemies");
        this.onUseEvent = this::onUseEvent;
        this.duringCooldownEvent = this::duringCooldownEvent;
    }

    private boolean onUseEvent(PlayerEntity player) {
        RayTraceResult mop = WyHelper.rayTraceBlocksAndEntities((Entity)player);
        double x = mop.func_216347_e().field_72450_a;
        double y = mop.func_216347_e().field_72448_b;
        double z = mop.func_216347_e().field_72449_c;
        this.posX = x;
        this.posY = y;
        this.posZ = z;
        RaigoProjectile proj = new RaigoProjectile(player.field_70170_p, (LivingEntity)player);
        proj.func_70012_b(x, y + 90.0, z, 0.0f, 0.0f);
        proj.func_213293_j(0.0, -2.0, 0.0);
        player.field_70170_p.func_217376_c((Entity)proj);
        return true;
    }

    private void duringCooldownEvent(PlayerEntity player, int cooldown) {
        if ((double)cooldown > this.getMaxCooldown() * 0.8 && cooldown % 10 == 0) {
            PARTICLES.spawn(player.field_70170_p, this.posX, this.posY + 40.0, this.posZ, 0.0, 0.0, 0.0);
        }
    }
}

