/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.gura;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.FallingBlockEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.ExplosionAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.FactionHelper;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.particles.effects.common.BlockParticlesEffect;
import xyz.pixelatedw.mineminenomi.particles.effects.gura.AirCrackParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.Ability;
import xyz.pixelatedw.mineminenomi.wypi.abilities.ChargeableAbility;

public class ShimaYurashiAbility
extends ChargeableAbility {
    public static final Ability INSTANCE = new ShimaYurashiAbility();
    private static final ParticleEffect PARTICLES = new BlockParticlesEffect(30, 800);
    private static final ParticleEffect AIR_GRAB_PARTICLES = new AirCrackParticleEffect();
    public List<FallingBlockEntity> entityBlocks = new ArrayList<FallingBlockEntity>();

    public ShimaYurashiAbility() {
        super("Shima Yurashi", AbilityHelper.getDevilFruitCategory());
        this.setMaxCooldown(60.0);
        this.setMaxChargeTime(5.0);
        this.setDescription("The user grabs the air and pulls it downwards after which the nearby land and entities are sent flying");
        this.onStartChargingEvent = this::onStartChargingEvent;
        this.duringChargingEvent = this::duringChargingEvent;
        this.onEndChargingEvent = this::onEndChargingEvent;
        this.duringCooldownEvent = this::duringCooldownEvent;
    }

    private boolean onStartChargingEvent(PlayerEntity player) {
        if (!player.field_70122_E) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_ONLY_IN_GROUND, new Object[]{this.getName()}));
            return false;
        }
        return CommonConfig.INSTANCE.isAbilityGriefingEnabled();
    }

    private void duringChargingEvent(PlayerEntity player, int chargeTime) {
        if (chargeTime % 2 == 0) {
            PARTICLES.spawn(player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), 0.0, 0.0, 0.0);
        }
        player.func_195064_c(new EffectInstance(ModEffects.MOVEMENT_BLOCKED, 10, 0, false, false));
        List targets = WyHelper.getEntitiesNear(player.func_180425_c(), player.field_70170_p, 26.0, FactionHelper.getOutsideGroupPredicate((LivingEntity)player), LivingEntity.class);
        targets.remove(player);
        targets.stream().filter(target -> target != null && target.func_70685_l((Entity)player) && target.func_70089_S() && target.field_70170_p.func_217299_a(new RayTraceContext(target.func_213303_ch(), target.func_213303_ch().func_72441_c(0.0, -10.0, 0.0), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.ANY, (Entity)target)).func_216346_c().equals((Object)RayTraceResult.Type.BLOCK)).forEach(target -> target.func_195064_c(new EffectInstance(ModEffects.DIZZY, 10, 0, false, false)));
    }

    private boolean onEndChargingEvent(PlayerEntity player) {
        List targets = WyHelper.getEntitiesNear(player.func_180425_c(), player.field_70170_p, 30.0, FactionHelper.getOutsideGroupPredicate((LivingEntity)player), LivingEntity.class);
        targets.remove(player);
        targets.stream().filter(target -> target != null && target.func_70089_S() && player.func_70685_l((Entity)target)).forEach(target -> {
            double damage = 20.0 + Math.sqrt(target.func_70068_e((Entity)player)) / 32.0 * 30.0;
            if (target.field_70122_E) {
                Vec3d speed = WyHelper.propulsion(target, damage / 25.0, damage / 25.0);
                target.func_213293_j(speed.field_72450_a, damage / 20.0, speed.field_72449_c);
                target.field_70133_I = true;
                damage *= 1.5;
            }
            target.func_70097_a(target.field_70122_E ? DamageSource.func_76365_a((PlayerEntity)player).func_76348_h() : DamageSource.func_76365_a((PlayerEntity)player), (float)damage);
        });
        this.entityBlocks.clear();
        EntityRayTraceResult trace = WyHelper.rayTraceEntities((Entity)player, 1.5);
        AIR_GRAB_PARTICLES.spawn(player.field_70170_p, trace.func_216347_e().func_82615_a(), player.func_226278_cu_() + 0.5, trace.func_216347_e().func_82616_c(), 0.0, 0.0, 0.0);
        ExplosionAbility explosion = AbilityHelper.newExplosion((Entity)player, player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), 30.0f);
        explosion.setSmokeParticles(PARTICLES);
        explosion.setStaticDamage(0.0f);
        explosion.setExplosionSound(false);
        explosion.setProtectOwnerFromFalling(true);
        explosion.addRemovedBlocksToList();
        explosion.doExplosion();
        this.entityBlocks.addAll(explosion.removedBlocks);
        player.field_70170_p.func_184133_a(null, player.func_180425_c(), ModSounds.GURA_SFX, SoundCategory.PLAYERS, 2.0f, 1.0f);
        return true;
    }

    private void duringCooldownEvent(PlayerEntity player, int i) {
        if (this.entityBlocks.isEmpty()) {
            return;
        }
        ArrayList<FallingBlockEntity> list = new ArrayList<FallingBlockEntity>();
        AxisAlignedBB box = new AxisAlignedBB(new BlockPos(player.func_213303_ch())).func_72314_b(40.0, 100.0, 40.0);
        for (FallingBlockEntity entity : player.field_70170_p.func_217357_a(FallingBlockEntity.class, box)) {
            if (entity != null && !list.contains(entity)) {
                list.add(entity);
            }
            if (list.size() <= 700) continue;
            IntStream.range(0, 70).forEach(j -> {
                ((FallingBlockEntity)list.get(j)).func_70106_y();
                list.remove(j);
            });
            return;
        }
        int size = 0;
        ArrayList<FallingBlockEntity> toRemove = new ArrayList<FallingBlockEntity>();
        for (FallingBlockEntity entity : this.entityBlocks) {
            entity.func_213293_j(WyHelper.randomWithRange(-2, 2), 1.0 + WyHelper.randomDouble() * 3.0, WyHelper.randomWithRange(-2, 2));
            entity.field_70133_I = true;
            entity.field_145813_c = false;
            entity.field_145812_b = 1;
            player.field_70170_p.func_217376_c((Entity)entity);
            toRemove.add(entity);
            if (++size <= 80) continue;
            break;
        }
        this.entityBlocks.removeAll(toRemove);
    }
}

