/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.hie;

import java.util.List;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SPlayEntityEffectPacket;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.SoundCategory;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.FactionHelper;
import xyz.pixelatedw.mineminenomi.api.protection.DefaultProtectionRules;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.particles.effects.hie.IceAgeParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.Ability;
import xyz.pixelatedw.mineminenomi.wypi.abilities.ChargeableAbility;

public class IceAgeAbility
extends ChargeableAbility {
    public static final Ability INSTANCE = new IceAgeAbility();
    public static final ParticleEffect PARTICLES = new IceAgeParticleEffect();

    public IceAgeAbility() {
        super("Ice Age", AbilityHelper.getDevilFruitCategory());
        this.setMaxCooldown(30.0);
        this.setMaxChargeTime(5.0);
        this.setCancelable();
        this.setDescription("Freezes a large area around the user and everyone inside of it");
        this.onEndChargingEvent = this::endChargingEvent;
    }

    private boolean endChargingEvent(PlayerEntity player) {
        player.field_70170_p.func_217384_a(null, (Entity)player, ModSounds.ICE_AGE_SFX, SoundCategory.PLAYERS, 1.0f, 1.0f);
        float time = (float)this.getChargeTime() / (float)this.getMaxChargeTime();
        float multiplier = 1.0f - time;
        int range = (int)(30.0f * multiplier);
        if (range < 4) {
            return false;
        }
        int r1 = (int)(10.0f * multiplier);
        int r2 = (int)(15.0f * multiplier);
        int r3 = (int)(6.25 * (double)multiplier);
        for (int i = -range; i < range; ++i) {
            for (int j = -10; j < 10; ++j) {
                for (int k = -range; k < range; ++k) {
                    double posX = player.func_226277_ct_() + (double)i + ((double)i < -WyHelper.randomWithRange(r1, r2) || (double)i > WyHelper.randomWithRange(r1, r2) ? WyHelper.randomWithRange(-r3, r3) : 0.0);
                    double posY = player.func_226278_cu_() + (double)j;
                    double posZ = player.func_226281_cx_() + (double)k + ((double)k < -WyHelper.randomWithRange(r1, r2) || (double)k > WyHelper.randomWithRange(r1, r2) ? WyHelper.randomWithRange(-r3, r3) : 0.0);
                    AbilityHelper.placeBlockIfAllowed(player.field_70170_p, posX, posY, posZ, Blocks.field_205164_gk, DefaultProtectionRules.CORE_FOLIAGE_ORE_LIQUID);
                }
            }
        }
        List<LivingEntity> list = WyHelper.getEntitiesNear(player.func_180425_c(), player.field_70170_p, (double)range, FactionHelper.getOutsideGroupPredicate((LivingEntity)player), LivingEntity.class);
        list.remove(player);
        for (LivingEntity target : list) {
            EffectInstance instance = new EffectInstance(ModEffects.FROZEN, 400, 0);
            target.func_195064_c(instance);
            ((ServerPlayerEntity)player).field_71135_a.func_147359_a((IPacket)new SPlayEntityEffectPacket(target.func_145782_y(), instance));
        }
        PARTICLES.spawn(player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), 0.0, 0.0, 0.0);
        this.setCooldown((int)(this.getMaxCooldown() / 20.0 * (double)multiplier));
        return true;
    }
}

