/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.horu;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SEntityVelocityPacket;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import xyz.pixelatedw.mineminenomi.api.abilities.ExplosionAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.particles.effects.horu.WinkExplosionEffect;
import xyz.pixelatedw.mineminenomi.particles.effects.horu.WinkParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.Ability;
import xyz.pixelatedw.mineminenomi.wypi.abilities.projectiles.AbilityProjectileEntity;

public class DeathWinkAbility
extends Ability {
    public static final DeathWinkAbility INSTANCE = new DeathWinkAbility();
    private static final ParticleEffect WINK = new WinkParticleEffect();

    public DeathWinkAbility() {
        super("Death Wink", AbilityHelper.getDevilFruitCategory());
        this.setMaxCooldown(6.0);
        this.setDescription("The user winks really hard creating a shockwave; Ganmen Seicho boosts it's power");
        this.onUseEvent = this::onUseEvent;
    }

    private boolean onUseEvent(PlayerEntity player) {
        Entity e;
        player.field_70170_p.func_184133_a(null, player.func_180425_c(), ModSounds.DEATH_WINK_SFX, SoundCategory.PLAYERS, 1.0f, 1.0f);
        EntityRayTraceResult trace = WyHelper.rayTraceEntities((Entity)player, 1.0);
        WINK.spawn(player.field_70170_p, trace.func_216347_e().func_82615_a(), player.func_226278_cu_(), trace.func_216347_e().func_82616_c(), 0.0, 0.0, 0.0);
        int power = player.func_70644_a(ModEffects.GANMEN_SEICHO_HORMONE) ? 3 : 2;
        boolean createExplosion = true;
        RayTraceResult mop = WyHelper.rayTraceBlocksAndEntities((Entity)player, 8 * power);
        double x = mop.func_216347_e().field_72450_a;
        double y = mop.func_216347_e().field_72448_b;
        double z = mop.func_216347_e().field_72449_c;
        if (mop instanceof EntityRayTraceResult && (e = ((EntityRayTraceResult)mop).func_216348_a()) instanceof AbilityProjectileEntity && ((AbilityProjectileEntity)e).getDamage() < (float)(power * 5)) {
            createExplosion = false;
            e.func_213293_j(-e.func_213322_ci().field_72450_a, e.func_213322_ci().field_72448_b, -e.func_213322_ci().field_72450_a);
        }
        if (createExplosion) {
            ExplosionAbility explosion = AbilityHelper.newExplosion((Entity)player, player.field_70170_p, x, y, z, 1 + power);
            explosion.setStaticDamage(power * 10);
            explosion.setExplosionSound(false);
            explosion.setSmokeParticles(new WinkExplosionEffect(2));
            explosion.doExplosion();
            double distance = Math.sqrt(player.func_70092_e(x, y, z));
            if (distance < 0.5) {
                player.func_213293_j(WyHelper.randomWithRange(-1, 1) * 0.5 * (double)power, 1.5 * (double)power, WyHelper.randomWithRange(-1, 1) * 0.5 * (double)power);
                ((ServerPlayerEntity)player).field_71135_a.func_147359_a((IPacket)new SEntityVelocityPacket((Entity)player));
            }
        }
        return true;
    }
}

