/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.ito;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.entities.mobs.ability.BlackKnightEntity;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.wypi.abilities.ContinuousAbility;
import xyz.pixelatedw.mineminenomi.wypi.abilities.IParallelContinuousAbility;

public class BlackKnightAbility
extends ContinuousAbility
implements IParallelContinuousAbility {
    public static final BlackKnightAbility INSTANCE = new BlackKnightAbility();
    private BlackKnightEntity knight = null;

    public BlackKnightAbility() {
        super("Black Knight", AbilityHelper.getDevilFruitCategory());
        this.setMaxCooldown(10.0);
        this.setThreshold(100.0);
        this.setDescription("Creates a clone of the user made entirely out of compressed strings\n\n\u00a72SHIFT-USE\u00a7r: Switches between AGGRESSIVE and DEFENSIVE modes");
        this.onStartContinuityEvent = this::onStartContinuityEvent;
        this.onEndContinuityEvent = this::onEndContinuityEvent;
    }

    private boolean onStartContinuityEvent(PlayerEntity player) {
        this.knight = new BlackKnightEntity(player.field_70170_p);
        this.knight.func_70080_a(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), player.field_70177_z, player.field_70125_A);
        this.knight.setOwner(player.func_110124_au());
        player.field_70170_p.func_217376_c((Entity)this.knight);
        return true;
    }

    private boolean onEndContinuityEvent(PlayerEntity player) {
        if (this.knight != null) {
            if (player.field_70122_E && player.func_225608_bj_()) {
                this.knight.isAggressive = !this.knight.isAggressive;
                String abilityName = new TranslationTextComponent(this.getI18nKey(), new Object[0]).func_150254_d();
                String puppetState = new TranslationTextComponent(this.knight.isAggressive ? ModI18n.ABILITY_PUPPET_STATE_AGGRESSIVE : ModI18n.ABILITY_PUPPET_STATE_DEFENSIVE, new Object[0]).func_150254_d();
                player.func_145747_a((ITextComponent)new TranslationTextComponent(ModI18n.ABILITY_PUPPET_STATE, new Object[]{abilityName, puppetState}));
                return false;
            }
            this.knight.func_70106_y();
        }
        return true;
    }
}

