/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.kilo;

import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SEntityVelocityPacket;
import net.minecraft.util.DamageSource;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.FactionHelper;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.ContinuousAbility;

public class KiloPress10000Ability
extends ContinuousAbility {
    public static final KiloPress10000Ability INSTANCE = new KiloPress10000Ability();
    private static final AttributeModifier KILO_PRESS = new AttributeModifier(UUID.fromString("692759d2-5d8d-4809-912d-86ad362f8f95"), "Kilo Press", -10.0, AttributeModifier.Operation.ADDITION);
    private static final AttributeModifier KILO_PRESS_KNOCKBACK = new AttributeModifier(UUID.fromString("f3597992-9268-4a40-9363-555cf06c7771"), "Kilo Press Knockback", 1.0, AttributeModifier.Operation.ADDITION);
    private double initialPosY = 0.0;

    public KiloPress10000Ability() {
        super("10,000 Kilo Press", AbilityHelper.getDevilFruitCategory());
        this.setDescription("Makes the user become extremely heavy, crashing down on enemies from above crushes them");
        this.setThreshold(60.0);
        this.onStartContinuityEvent = this::onStartContinuityEvent;
        this.duringContinuityEvent = this::duringContinuityEvent;
        this.onEndContinuityEvent = this::onEndContinuityEvent;
    }

    private boolean onStartContinuityEvent(PlayerEntity player) {
        player.func_110148_a(ModAttributes.JUMP_HEIGHT).func_111121_a(KILO_PRESS);
        player.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111121_a(KILO_PRESS_KNOCKBACK);
        player.func_213293_j(player.func_213322_ci().field_72450_a, -5.0, player.func_213322_ci().field_72449_c);
        ((ServerPlayerEntity)player).field_71135_a.func_147359_a((IPacket)new SEntityVelocityPacket((Entity)player));
        this.initialPosY = !player.field_70122_E ? player.func_226278_cu_() : 0.0;
        return true;
    }

    private void duringContinuityEvent(PlayerEntity player, int time) {
        double damage;
        player.field_70143_R = 0.0f;
        if (player.field_70122_E && this.initialPosY > 0.0 && player.func_226278_cu_() < this.initialPosY && (damage = Math.min(this.initialPosY - player.func_226278_cu_(), 80.0)) > 0.0) {
            List<LivingEntity> targets = WyHelper.getEntitiesNear(player.func_180425_c(), player.field_70170_p, 5.0, FactionHelper.getOutsideGroupPredicate((LivingEntity)player), LivingEntity.class);
            targets.remove(player);
            for (LivingEntity entity : targets) {
                entity.func_70097_a(DamageSource.func_76365_a((PlayerEntity)player), (float)damage);
            }
            this.initialPosY = 0.0;
        }
    }

    private boolean onEndContinuityEvent(PlayerEntity player) {
        player.func_110148_a(ModAttributes.JUMP_HEIGHT).func_111124_b(KILO_PRESS);
        player.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111124_b(KILO_PRESS_KNOCKBACK);
        int cooldown = (int)Math.round((double)this.continueTime / 20.0);
        this.setMaxCooldown(cooldown);
        return true;
    }
}

