/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.kira;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import xyz.pixelatedw.mineminenomi.abilities.kira.DiamondBodyAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.IMultiTargetAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.FactionHelper;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.Ability;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.IAbilityData;

public class BrilliantPunkAbility
extends Ability
implements IMultiTargetAbility {
    public static final BrilliantPunkAbility INSTANCE = new BrilliantPunkAbility();

    public BrilliantPunkAbility() {
        super("Brilliant Punk", AbilityHelper.getDevilFruitCategory());
        this.setMaxCooldown(10.0);
        this.setDescription("The user rams into the target with their diamond body");
        this.onUseEvent = this::onUseEvent;
        this.duringCooldownEvent = this::duringCooldown;
    }

    private boolean onUseEvent(PlayerEntity player) {
        boolean diamondBodyActive;
        if (!AbilityHelper.canUseMomentumAbility(player)) {
            return false;
        }
        this.clearTargets();
        IAbilityData abilityProps = AbilityDataCapability.get((LivingEntity)player);
        DiamondBodyAbility ability = abilityProps.getEquippedAbility(DiamondBodyAbility.INSTANCE);
        boolean bl = diamondBodyActive = ability != null && ability.isContinuous();
        if (!diamondBodyActive) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_NOT_ZOAN_FORM_SINGLE, new Object[]{this.getName(), DiamondBodyAbility.INSTANCE.getName()}));
            return false;
        }
        Vec3d speed = WyHelper.propulsion((LivingEntity)player, 3.0, 3.0);
        player.func_213293_j(speed.field_72450_a, 0.2, speed.field_72449_c);
        player.field_70133_I = true;
        return true;
    }

    private void duringCooldown(PlayerEntity player, int cooldownTimer) {
        if (this.canDealDamage()) {
            List<LivingEntity> list = WyHelper.getEntitiesNear(player.func_180425_c(), player.field_70170_p, 1.6, FactionHelper.getOutsideGroupPredicate((LivingEntity)player), LivingEntity.class);
            list.remove(player);
            list.forEach(entity -> {
                if (this.isTarget((LivingEntity)entity) && player.func_70685_l((Entity)entity)) {
                    entity.func_70097_a(DamageSource.func_76365_a((PlayerEntity)player), 15.0f);
                }
            });
        }
    }

    public boolean canDealDamage() {
        return this.cooldown > this.getMaxCooldown() * 0.9;
    }
}

