/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.mera;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.extra.KairosekiBulletProjectile;
import xyz.pixelatedw.mineminenomi.entities.projectiles.extra.NormalBulletProjectile;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.particles.effects.mera.KyokaenParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.ContinuousAbility;
import xyz.pixelatedw.mineminenomi.wypi.abilities.events.SetOnFireEvent;

public class KyokaenAbility
extends ContinuousAbility {
    public static final KyokaenAbility INSTANCE = new KyokaenAbility();
    private static final KyokaenParticleEffect PARTICLES = new KyokaenParticleEffect();

    public KyokaenAbility() {
        super("Kyokaen", AbilityHelper.getDevilFruitCategory());
        this.setDescription("Creates a wall of fire protecting the user");
        this.setThreshold(5.0);
        this.duringContinuityEvent = this::duringContinuity;
        this.onEndContinuityEvent = this::onEndContinuityEvent;
    }

    private void duringContinuity(PlayerEntity player, int passiveTimer) {
        int range = 2;
        double boxSize = 1.1;
        for (int i = 0; i < range * 2; ++i) {
            double distance = (double)i / 2.0;
            Vec3d lookVec = player.func_70040_Z();
            Vec3d pos = new Vec3d(player.func_226277_ct_() + lookVec.field_72450_a * distance, player.func_226278_cu_() + (double)player.func_70047_e() + lookVec.field_72448_b * distance, player.func_226281_cx_() + lookVec.field_72449_c * distance);
            List list = player.field_70170_p.func_175674_a((Entity)player, new AxisAlignedBB(pos.field_72450_a - boxSize, pos.field_72448_b - boxSize, pos.field_72449_c - boxSize, pos.field_72450_a + boxSize, pos.field_72448_b + boxSize * 2.0, pos.field_72449_c + boxSize), entity -> entity != player);
            for (Entity e : list) {
                if (e instanceof LivingEntity) {
                    if (!e.func_70027_ad()) {
                        SetOnFireEvent event = new SetOnFireEvent((LivingEntity)player, (LivingEntity)e, 3);
                        if (!MinecraftForge.EVENT_BUS.post((Event)event)) {
                            e.func_70015_d(3);
                        }
                        e.func_70097_a(ModDamageSource.FIRE.getSource(), 3.0f);
                    }
                    Vec3d speed = WyHelper.propulsion((LivingEntity)player, 3.0, 3.0);
                    e.func_213293_j(speed.field_72450_a, 0.5, speed.field_72449_c);
                    e.field_70133_I = true;
                    continue;
                }
                if (e instanceof AbstractArrowEntity || e instanceof KairosekiBulletProjectile || e instanceof NormalBulletProjectile) {
                    e.func_70106_y();
                    continue;
                }
                if (!(e instanceof ThrowableEntity)) continue;
                e.func_213293_j(-e.func_213322_ci().field_72450_a * (double)1.35f, e.func_213322_ci().field_72448_b, -e.func_213322_ci().field_72450_a * (double)1.35f);
            }
        }
        EntityRayTraceResult trace = WyHelper.rayTraceEntities((Entity)player, range);
        if (passiveTimer % 2 == 0) {
            PARTICLES.spawn(player.field_70170_p, trace.func_216347_e().func_82615_a(), player.func_226278_cu_(), trace.func_216347_e().func_82616_c(), 0.0, 0.0, 0.0);
        }
    }

    private boolean onEndContinuityEvent(PlayerEntity player) {
        int cooldown = 2 + (int)Math.round((double)this.continueTime / 20.0);
        this.setMaxCooldown(cooldown);
        return true;
    }
}

