/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.moku;

import java.util.List;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.EffectInstance;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.particles.effects.moku.WhiteStrikeParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.Ability;

public class WhiteStrikeAbility
extends Ability {
    public static final Ability INSTANCE = new WhiteStrikeAbility();
    private static final ParticleEffect PARTICLES = new WhiteStrikeParticleEffect();

    public WhiteStrikeAbility() {
        super("White Strike", AbilityHelper.getDevilFruitCategory());
        this.setMaxCooldown(20.0);
        this.setDescription("Surrounds the nearby area with smoke, slowing down nearby entities");
        this.onUseEvent = this::onUseEvent;
        this.duringCooldownEvent = this::duringCooldownEvent;
    }

    private boolean onUseEvent(PlayerEntity player) {
        List<LivingEntity> targets = WyHelper.getEntitiesNear(player.func_180425_c(), player.field_70170_p, 10.0, LivingEntity.class);
        targets.remove(player);
        targets.forEach(entity -> entity.func_195064_c(new EffectInstance(ModEffects.SMOKE, 800, 0, false, false)));
        return true;
    }

    private void duringCooldownEvent(PlayerEntity player, int cooldown) {
        if ((double)cooldown > WyHelper.percentage(80.0, this.maxCooldown)) {
            PARTICLES.spawn(player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), 0.0, 0.0, 0.0);
        }
    }
}

