/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.nikyu;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.SoundCategory;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.nikyu.ChargingUrsusShockEntity;
import xyz.pixelatedw.mineminenomi.entities.projectiles.nikyu.UrsusShockProjectile;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.wypi.abilities.Ability;
import xyz.pixelatedw.mineminenomi.wypi.abilities.ChargeableAbility;

public class UrsusShockAbility
extends ChargeableAbility {
    public static final Ability INSTANCE = new UrsusShockAbility();
    private int power = 0;
    private ChargingUrsusShockEntity ursusShockEntity;

    public UrsusShockAbility() {
        super("Ursus Shock", AbilityHelper.getDevilFruitCategory());
        this.setDescription("The user compresses air and sends it towards the opponent to create a huge shockwave");
        this.setMaxCooldown(20.0);
        this.setMaxChargeTime(16.0);
        this.duringChargingEvent = this::duringChargingEvent;
        this.onStartChargingEvent = this::onStartChargingEvent;
        this.onEndChargingEvent = this::onEndChargingEvent;
    }

    private void duringChargingEvent(PlayerEntity player, int chargeTimer) {
        if (this.ursusShockEntity == null) {
            this.stopCharging(player);
            return;
        }
        this.power = chargeTimer;
        double truePower = Math.abs(this.power - this.getMaxChargeTime());
        float currentCharge = this.ursusShockEntity.getCharge();
        if (-5.0f > currentCharge) {
            this.ursusShockEntity.func_70106_y();
        } else {
            currentCharge = (float)((double)currentCharge + (truePower < 190.0 ? 0.025 : -0.035));
            this.ursusShockEntity.setCharge(currentCharge);
        }
    }

    private boolean onStartChargingEvent(PlayerEntity player) {
        player.field_70170_p.func_217384_a(null, (Entity)player, ModSounds.URSUS_SHOCK_SFX, SoundCategory.PLAYERS, 2.0f, 2.0f);
        ChargingUrsusShockEntity entity = new ChargingUrsusShockEntity(player.field_70170_p);
        entity.setOwner((LivingEntity)player);
        entity.func_70080_a(player.func_226277_ct_(), player.func_226278_cu_() + 2.0, player.func_226281_cx_(), 0.0f, 0.0f);
        player.field_70170_p.func_217376_c((Entity)entity);
        this.ursusShockEntity = entity;
        return true;
    }

    private boolean onEndChargingEvent(PlayerEntity player) {
        if (this.getChargeTime() > this.getMaxChargeTime() - 190) {
            return false;
        }
        float multiplier = 1.0f - (float)this.getChargeTime() / (float)this.getMaxChargeTime();
        UrsusShockProjectile projectile = new UrsusShockProjectile(player.field_70170_p, (LivingEntity)player);
        projectile.multiplier = multiplier;
        projectile.setSize((double)multiplier > 0.75 ? 0.6f : 5.0f * (1.0f - multiplier));
        this.setMaxCooldown(20.0f * multiplier);
        player.field_70170_p.func_217376_c((Entity)projectile);
        projectile.func_184538_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, 0.5f, 0.0f);
        if (this.ursusShockEntity != null) {
            this.ursusShockEntity.func_70106_y();
        }
        return true;
    }
}

