/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.pika;

import java.util.List;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.FactionHelper;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.particles.effects.pika.ChargingPikaParticleEvent;
import xyz.pixelatedw.mineminenomi.particles.effects.pika.FlashParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.Ability;
import xyz.pixelatedw.mineminenomi.wypi.abilities.ChargeableAbility;

public class FlashAbility
extends ChargeableAbility {
    public static final Ability INSTANCE = new FlashAbility();
    private static final ParticleEffect PARTICLES = new FlashParticleEffect();
    private static final ParticleEffect CHARGE_PARTICLE = new ChargingPikaParticleEvent();

    public FlashAbility() {
        super("Flash", AbilityHelper.getDevilFruitCategory());
        this.setMaxCooldown(15.0);
        this.setMaxChargeTime(5.0);
        this.setCancelable();
        this.setDescription("The user creates a bright flash of light, blinding their opponents");
        this.duringChargingEvent = this::duringChargingEvent;
        this.onEndChargingEvent = this::onEndChargingEvent;
    }

    private void duringChargingEvent(PlayerEntity player, int timer) {
        CHARGE_PARTICLE.spawn(player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), 0.0, 0.0, 0.0);
    }

    private boolean onEndChargingEvent(PlayerEntity player) {
        float time = (float)this.getChargeTime() / (float)this.getMaxChargeTime();
        float radius = (1.0f - time) * 16.0f;
        List<LivingEntity> list = WyHelper.getEntitiesNear(player.func_180425_c(), player.field_70170_p, (double)radius, FactionHelper.getOutsideGroupPredicate((LivingEntity)player), LivingEntity.class);
        list.remove(player);
        list.forEach(entity -> {
            entity.func_195064_c(new EffectInstance(Effects.field_76440_q, 140, 3));
            entity.func_195064_c(new EffectInstance(ModEffects.MOVEMENT_BLOCKED, 60, 0));
            PARTICLES.spawn(player.field_70170_p, entity.func_226277_ct_(), entity.func_226278_cu_() + (double)entity.func_70047_e(), entity.func_226281_cx_(), 0.0, 0.0, 0.0);
        });
        return true;
    }
}

