/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.suna;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.RayTraceResult;
import xyz.pixelatedw.mineminenomi.abilities.suna.DesertGirasoleAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.suna.SablesProjectile;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.Ability;
import xyz.pixelatedw.mineminenomi.wypi.abilities.ChargeableAbility;

public class SablesAbility
extends ChargeableAbility {
    public static final Ability INSTANCE = new SablesAbility();
    SablesProjectile proj = null;
    float maxMultiplier = 0.0f;

    public SablesAbility() {
        super("Sables", AbilityHelper.getDevilFruitCategory());
        this.setMaxCooldown(18.0);
        this.setMaxChargeTime(6.0);
        this.setDescription("The user launches a compressed sandstorm at the opponent, which sends them flying");
        this.onStartChargingEvent = this::onStartChargingEvent;
        this.duringChargingEvent = this::duringContinuity;
        this.onEndChargingEvent = this::onEndChargingEvent;
    }

    private boolean onStartChargingEvent(PlayerEntity player) {
        this.proj = null;
        this.maxMultiplier = DesertGirasoleAbility.isFruitBoosted(player) ? 2 : 1;
        return !player.func_70026_G();
    }

    private boolean onEndChargingEvent(PlayerEntity player) {
        if (this.proj.func_70089_S()) {
            this.proj.func_184538_a((Entity)player, 0.0f, 0.0f, 0.0f, 2.0f, 0.0f);
        }
        return true;
    }

    private void duringContinuity(PlayerEntity player, int i) {
        RayTraceResult mop = WyHelper.rayTraceBlocksAndEntities((Entity)player, 100.0);
        if (this.proj == null) {
            this.proj = new SablesProjectile(player.field_70170_p, (LivingEntity)player);
            this.proj.func_70107_b(player.func_226277_ct_(), player.func_226278_cu_() + 10.0, player.func_226281_cx_());
            player.field_70170_p.func_217376_c((Entity)this.proj);
        }
        if (!this.proj.func_70089_S() || this.proj == null) {
            this.proj = null;
            this.stopCharging(player);
        }
        float time = (float)this.getChargeTime() / (float)this.getMaxChargeTime();
        float multiplier = 1.0f - time;
        this.proj.mult = this.maxMultiplier * multiplier;
        double distance = Math.sqrt(this.proj.func_195048_a(mop.func_216347_e()));
        if (mop.func_216346_c().equals((Object)RayTraceResult.Type.BLOCK) && distance < 100.0) {
            this.proj.vector = mop.func_216347_e().func_72441_c(0.0, 10.0, 0.0);
        }
    }
}

