/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.supa;

import java.util.List;
import net.minecraft.block.Blocks;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import xyz.pixelatedw.mineminenomi.api.abilities.IMultiTargetAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.FactionHelper;
import xyz.pixelatedw.mineminenomi.api.protection.DefaultProtectionRules;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.particles.effects.baku.BakuMunchParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.Ability;

public class SparklingDaisyAbility
extends Ability
implements IMultiTargetAbility {
    public static final SparklingDaisyAbility INSTANCE = new SparklingDaisyAbility();
    private static final ParticleEffect PARTICLES = new BakuMunchParticleEffect();
    private int initialY;

    public SparklingDaisyAbility() {
        super("Sparkling Daisy", AbilityHelper.getDevilFruitCategory());
        this.setDescription("Launches the user forward, slicing anything in their path");
        this.setMaxCooldown(7.0);
        this.onUseEvent = this::onUseEvent;
        this.duringCooldownEvent = this::duringCooldownEvent;
    }

    private boolean onUseEvent(PlayerEntity player) {
        if (!AbilityHelper.canUseMomentumAbility(player)) {
            return false;
        }
        this.clearTargets();
        this.initialY = (int)player.func_226278_cu_();
        double[] motion = AbilityHelper.propulsion((LivingEntity)player, 3.0, 3.0);
        player.func_213293_j(motion[0], player.func_213322_ci().field_72448_b, motion[1]);
        player.field_70133_I = true;
        return true;
    }

    private void duringCooldownEvent(PlayerEntity player, int cooldownTimer) {
        if (this.getCooldown() > this.getMaxCooldown() * 0.9 && player.func_226278_cu_() >= (double)this.initialY) {
            List<LivingEntity> list = WyHelper.getEntitiesNear(player.func_180425_c(), player.field_70170_p, 1.6, FactionHelper.getOutsideGroupPredicate((LivingEntity)player), LivingEntity.class);
            list.remove(player);
            list.forEach(entity -> {
                if (this.isTarget((LivingEntity)entity)) {
                    entity.func_70097_a(DamageSource.func_76365_a((PlayerEntity)player), 25.0f);
                }
            });
            for (BlockPos location : WyHelper.getNearbyBlocks((LivingEntity)player, 3)) {
                if (!((double)location.func_177956_o() >= player.func_226278_cu_()) || !AbilityHelper.placeBlockIfAllowed(player.field_70170_p, location.func_177958_n(), location.func_177956_o(), location.func_177952_p(), Blocks.field_150350_a, DefaultProtectionRules.CORE_FOLIAGE_ORE)) continue;
                PARTICLES.spawn(player.field_70170_p, location.func_177958_n(), location.func_177956_o(), location.func_177952_p(), 0.0, 0.0, 0.0);
            }
        }
    }
}

