/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.wara;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.api.abilities.HurtPassiveAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.DevilFruitHelper;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModItems;
import xyz.pixelatedw.mineminenomi.items.StrawDollItem;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class LifeMinusAbility
extends HurtPassiveAbility {
    public static final LifeMinusAbility INSTANCE = new LifeMinusAbility();

    public LifeMinusAbility() {
        super("Life Minus", AbilityHelper.getDevilFruitCategory());
        this.setDescription("Transfers the damage taken to a Straw Doll in your inventory");
        this.hideInGUI(false);
        this.onHurtEvent = this::onHurtEvent;
    }

    private boolean onHurtEvent(LivingEntity entity, Entity source) {
        boolean canUseDoll;
        if (!(entity instanceof PlayerEntity)) {
            return true;
        }
        boolean bl = canUseDoll = !AbilityHelper.isAffectedByWater(entity) && !entity.func_70644_a(ModEffects.ABILITY_OFF) && !DevilFruitHelper.kairosekiChecks(entity);
        if (!canUseDoll) {
            return true;
        }
        PlayerEntity attacked = (PlayerEntity)entity;
        for (int i = 0; i < attacked.field_71071_by.field_70462_a.size(); ++i) {
            ItemStack stack = attacked.field_71071_by.func_70301_a(i);
            if (stack.func_77973_b() != ModItems.STRAW_DOLL) continue;
            LivingEntity strawDollOwner = ((StrawDollItem)stack.func_77973_b()).getOwner(attacked.field_70170_p, attacked.func_180425_c(), stack);
            if (strawDollOwner == null) {
                attacked.field_71071_by.func_184437_d(stack);
                continue;
            }
            boolean attack = strawDollOwner.func_70097_a(DamageSource.field_76380_i, this.getAmount());
            if (attack && 0.0f > strawDollOwner.func_110143_aJ() - this.getAmount()) {
                this.spawnParticles((ServerWorld)attacked.field_70170_p, attacked.func_226277_ct_(), attacked.func_226278_cu_(), attacked.func_226281_cx_());
                this.spawnParticles((ServerWorld)strawDollOwner.field_70170_p, strawDollOwner.func_226277_ct_(), strawDollOwner.func_226278_cu_(), strawDollOwner.func_226281_cx_());
                attacked.field_71071_by.func_184437_d(stack);
            }
            return false;
        }
        return true;
    }

    private void spawnParticles(ServerWorld world, double posX, double posY, double posZ) {
        for (int i = 0; i < 5; ++i) {
            double offsetX = WyHelper.randomDouble() / 2.0;
            double offsetY = WyHelper.randomDouble() / 2.0;
            double offsetZ = WyHelper.randomDouble() / 2.0;
            world.func_195598_a((IParticleData)ParticleTypes.field_197616_i, posX + offsetX, posY + offsetY, posZ + offsetZ, 25, 0.0, 0.0, 0.0, 0.1);
        }
    }
}

