/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.yami;

import java.util.List;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.FactionHelper;
import xyz.pixelatedw.mineminenomi.api.protection.BlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.block.AirBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.init.ModBlocks;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.particles.effects.yami.BlackWorldParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.Ability;

public class BlackWorldAbility
extends Ability {
    public static final BlackWorldAbility INSTANCE = new BlackWorldAbility();
    private static final ParticleEffect PARTICLES = new BlackWorldParticleEffect();
    private static final BlockProtectionRule GRIEF_RULE = AirBlockProtectionRule.INSTANCE;

    public BlackWorldAbility() {
        super("Black World", AbilityHelper.getDevilFruitCategory());
        this.setDescription("The user spreads their power to the surroundings, blinding enemies and creating pillars of Darkness");
        this.setMaxCooldown(10.0);
        this.onUseEvent = this::onUseEvent;
    }

    private boolean onUseEvent(PlayerEntity player) {
        PARTICLES.spawn(player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), 0.0, 0.0, 0.0);
        for (int i = 0; i < 8; ++i) {
            int a1 = (int)WyHelper.randomWithRange(-10, 10);
            int a2 = (int)WyHelper.randomWithRange(-10, 10);
            for (int j = -5; j < 5; ++j) {
                AbilityHelper.placeBlockIfAllowed(player.field_70170_p, (int)player.func_226277_ct_() + a1, (int)player.func_226278_cu_() + j, (int)player.func_226281_cx_() + a2, ModBlocks.DARKNESS, GRIEF_RULE);
                AbilityHelper.placeBlockIfAllowed(player.field_70170_p, (int)player.func_226277_ct_() + a1 + 1, (int)player.func_226278_cu_() + j, (int)player.func_226281_cx_() + a2, ModBlocks.DARKNESS, GRIEF_RULE);
                AbilityHelper.placeBlockIfAllowed(player.field_70170_p, (int)player.func_226277_ct_() + a1, (int)player.func_226278_cu_() + j, (int)player.func_226281_cx_() + a2 + 1, ModBlocks.DARKNESS, GRIEF_RULE);
                AbilityHelper.placeBlockIfAllowed(player.field_70170_p, (int)player.func_226277_ct_() + a1 + 1, (int)player.func_226278_cu_() + j, (int)player.func_226281_cx_() + a2 + 1, ModBlocks.DARKNESS, GRIEF_RULE);
            }
        }
        List<LivingEntity> targets = WyHelper.getEntitiesNear(player.func_180425_c(), player.field_70170_p, 20.0, FactionHelper.getOutsideGroupPredicate((LivingEntity)player), LivingEntity.class);
        targets.remove(player);
        for (LivingEntity target : targets) {
            target.func_195064_c(new EffectInstance(Effects.field_76440_q, 200, 1, false, false));
            target.func_195064_c(new EffectInstance(Effects.field_76421_d, 200, 1, false, false));
        }
        return true;
    }
}

