/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.yami;

import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.yami.LiberationProjectile;
import xyz.pixelatedw.mineminenomi.init.ModBlocks;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.Ability;

public class LiberationAbility
extends Ability {
    public static final LiberationAbility INSTANCE = new LiberationAbility();
    private int liberationCount = 0;

    public LiberationAbility() {
        super("Liberation", AbilityHelper.getDevilFruitCategory());
        this.setDescription("The user sucks up any Darkness they placed, then expells everything sucked up at the target location");
        this.setMaxCooldown(4.0);
        this.onUseEvent = this::onUseEvent;
    }

    private boolean onUseEvent(PlayerEntity player) {
        if (this.liberationCount > 0) {
            RayTraceResult mop = WyHelper.rayTraceBlocksAndEntities((Entity)player);
            double x = mop.func_216347_e().field_72450_a;
            double y = mop.func_216347_e().field_72448_b;
            double z = mop.func_216347_e().field_72449_c;
            while (this.liberationCount > 0) {
                LiberationProjectile proj = new LiberationProjectile(player.field_70170_p, (LivingEntity)player);
                proj.func_70012_b(x + WyHelper.randomWithRange(-3, 3), y + 14.0 + WyHelper.randomWithRange(0, 4), z + WyHelper.randomWithRange(-3, 3), 0.0f, 0.0f);
                proj.func_213293_j(0.0, -0.7 - player.field_70170_p.field_73012_v.nextDouble(), 0.0);
                player.field_70170_p.func_217376_c((Entity)proj);
                --this.liberationCount;
            }
        } else {
            int libCount = 0;
            for (int x = -40; x < 40; ++x) {
                for (int y = -40; y < 40; ++y) {
                    for (int z = -40; z < 40; ++z) {
                        BlockPos pos = new BlockPos((int)player.func_226277_ct_() + x, (int)player.func_226278_cu_() + y, (int)player.func_226281_cx_() + z);
                        if (player.field_70170_p.func_180495_p(pos).func_177230_c() != ModBlocks.DARKNESS) continue;
                        player.field_70170_p.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
                        if (++libCount % 10 != 0) continue;
                        ++this.liberationCount;
                    }
                }
            }
        }
        return true;
    }
}

