/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.yomi;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SEntityVelocityPacket;
import net.minecraft.network.play.server.SPlayEntityEffectPacket;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.IMultiTargetAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.FactionHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.ItemsHelper;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.particles.effects.yomi.KasuriutaFubukiGiriParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.Ability;

public class KasuriutaFubukiGiriAbility
extends Ability
implements IMultiTargetAbility {
    public static final KasuriutaFubukiGiriAbility INSTANCE = new KasuriutaFubukiGiriAbility();
    private static final ParticleEffect PARTICLES = new KasuriutaFubukiGiriParticleEffect();

    public KasuriutaFubukiGiriAbility() {
        super("Kasuriuta: Fubuki Giri", AbilityHelper.getDevilFruitCategory());
        this.setDescription("A quick slash at the enemy that also freezes them");
        this.setMaxCooldown(8.0);
        this.onUseEvent = this::onUseEvent;
        this.duringCooldownEvent = this::duringCooldown;
    }

    private boolean onUseEvent(PlayerEntity player) {
        if (!AbilityHelper.canUseMomentumAbility(player)) {
            return false;
        }
        if (!ItemsHelper.isSword(player.func_184614_ca())) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_NEED_SWORD, new Object[0]));
            return false;
        }
        this.clearTargets();
        Vec3d speed = WyHelper.propulsion((LivingEntity)player, 5.0, 5.0);
        player.func_213293_j(speed.field_72450_a, player.func_213322_ci().field_72448_b, speed.field_72449_c);
        ((ServerPlayerEntity)player).field_71135_a.func_147359_a((IPacket)new SEntityVelocityPacket((Entity)player));
        return true;
    }

    private void duringCooldown(PlayerEntity player, int cooldownTimer) {
        if (this.canDealDamage()) {
            if (cooldownTimer % 2 == 0) {
                PARTICLES.spawn(player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), 0.0, 0.0, 0.0);
            }
            List<LivingEntity> list = WyHelper.getEntitiesNear(player.func_180425_c(), player.field_70170_p, 1.6, FactionHelper.getOutsideGroupPredicate((LivingEntity)player), LivingEntity.class);
            list.remove(player);
            for (LivingEntity target : list) {
                if (!this.isTarget(target) || !player.func_70685_l((Entity)target)) continue;
                target.func_70097_a(DamageSource.func_76365_a((PlayerEntity)player), 8.0f);
                EffectInstance instance = new EffectInstance(ModEffects.FROZEN, 100, 0);
                target.func_195064_c(instance);
                ((ServerPlayerEntity)player).field_71135_a.func_147359_a((IPacket)new SPlayEntityEffectPacket(target.func_145782_y(), instance));
            }
        }
    }

    public boolean canDealDamage() {
        return this.cooldown > 140.0;
    }
}

