/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.crew;

import java.util.Arrays;
import java.util.stream.Stream;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.GameRegistry;
import xyz.pixelatedw.mineminenomi.api.crew.JollyRogerElement;
import xyz.pixelatedw.mineminenomi.init.ModJollyRogers;

public class JollyRoger {
    private JollyRogerElement base = ModJollyRogers.BASE_0;
    private JollyRogerElement[] backgrounds = new JollyRogerElement[2];
    private JollyRogerElement[] details = new JollyRogerElement[5];

    public CompoundNBT write() {
        CompoundNBT baseNBT;
        CompoundNBT nbt = new CompoundNBT();
        JollyRogerElement baseElement = this.getBase();
        if (baseElement != null && baseElement.getTexture() != null) {
            baseNBT = new CompoundNBT();
            baseNBT.func_74778_a("id", baseElement.getTexture().toString());
            baseNBT.func_74757_a("canBeColored", baseElement.canBeColored());
            baseNBT.func_74778_a("color", baseElement.getColor());
            nbt.func_218657_a("base", (INBT)baseNBT);
        } else {
            baseNBT = new CompoundNBT();
            baseNBT.func_74778_a("id", "empty");
            nbt.func_218657_a("base", (INBT)baseNBT);
        }
        try {
            ListNBT backgrounds = new ListNBT();
            for (int i = 0; i < this.getBackgrounds().length; ++i) {
                CompoundNBT backgroundNBT;
                JollyRogerElement bgElement = this.getBackgrounds()[i];
                if (bgElement != null && bgElement.getTexture() != null) {
                    backgroundNBT = new CompoundNBT();
                    backgroundNBT.func_74768_a("slot", i);
                    backgroundNBT.func_74778_a("id", bgElement.getTexture().toString());
                    backgroundNBT.func_74757_a("canBeColored", bgElement.canBeColored());
                    backgroundNBT.func_74778_a("color", bgElement.getColor());
                    backgrounds.add((Object)backgroundNBT);
                    continue;
                }
                backgroundNBT = new CompoundNBT();
                backgroundNBT.func_74768_a("slot", i);
                backgroundNBT.func_74778_a("id", "empty");
                backgrounds.add((Object)backgroundNBT);
            }
            nbt.func_218657_a("backgrounds", (INBT)backgrounds);
            ListNBT details = new ListNBT();
            for (int i = 0; i < this.getDetails().length; ++i) {
                CompoundNBT detailNBT;
                JollyRogerElement detElement = this.getDetails()[i];
                if (detElement != null && detElement.getTexture() != null) {
                    detailNBT = new CompoundNBT();
                    detailNBT.func_74768_a("slot", i);
                    detailNBT.func_74778_a("id", detElement.getTexture().toString());
                    detailNBT.func_74757_a("canBeColored", detElement.canBeColored());
                    detailNBT.func_74778_a("color", detElement.getColor());
                    details.add((Object)detailNBT);
                    continue;
                }
                detailNBT = new CompoundNBT();
                detailNBT.func_74768_a("slot", i);
                detailNBT.func_74778_a("id", "empty");
                details.add((Object)detailNBT);
            }
            nbt.func_218657_a("details", (INBT)details);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return nbt;
    }

    public void read(CompoundNBT nbt) {
        try {
            String color;
            int slot;
            CompoundNBT baseNBT = nbt.func_74775_l("base");
            JollyRogerElement baseElement = (JollyRogerElement)GameRegistry.findRegistry(JollyRogerElement.class).getValue(new ResourceLocation("mineminenomi", baseNBT.func_74779_i("id").replace("mineminenomi:", "")));
            if (baseElement != null) {
                if (baseNBT.func_74767_n("canBeColored")) {
                    baseElement.setCanBeColored();
                }
                String color2 = baseNBT.func_74779_i("color");
                baseElement.setColor(color2);
                this.setBase(baseElement);
            } else {
                this.setBase(null);
            }
            ListNBT backgroundsNBT = nbt.func_150295_c("backgrounds", 10);
            for (int i = 0; i < backgroundsNBT.size(); ++i) {
                CompoundNBT backgroundNBT = backgroundsNBT.func_150305_b(i);
                ResourceLocation res = new ResourceLocation("mineminenomi", backgroundNBT.func_74779_i("id").replace("mineminenomi:", ""));
                JollyRogerElement bgElement = (JollyRogerElement)GameRegistry.findRegistry(JollyRogerElement.class).getValue(res);
                slot = backgroundNBT.func_74762_e("slot");
                if (bgElement != null) {
                    if (backgroundNBT.func_74767_n("canBeColored")) {
                        bgElement.setCanBeColored();
                    }
                    color = backgroundNBT.func_74779_i("color");
                    bgElement.setColor(color);
                    this.setBackground(slot, bgElement);
                    continue;
                }
                this.setBackground(slot, null);
            }
            ListNBT detailsNBT = nbt.func_150295_c("details", 10);
            for (int i = 0; i < detailsNBT.size(); ++i) {
                CompoundNBT detailNBT = detailsNBT.func_150305_b(i);
                JollyRogerElement detElement = (JollyRogerElement)GameRegistry.findRegistry(JollyRogerElement.class).getValue(new ResourceLocation("mineminenomi", detailNBT.func_74779_i("id").replace("mineminenomi:", "")));
                slot = detailNBT.func_74762_e("slot");
                if (detElement != null) {
                    if (detailNBT.func_74767_n("canBeColored")) {
                        detElement.setCanBeColored();
                    }
                    color = detailNBT.func_74779_i("color");
                    detElement.setColor(color);
                    this.setDetail(slot, detElement);
                    continue;
                }
                this.setDetail(slot, null);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public JollyRogerElement getBase() {
        return this.base;
    }

    public void setBase(JollyRogerElement base) {
        this.base = base;
    }

    public JollyRogerElement[] getBackgrounds() {
        return this.backgrounds;
    }

    public void setBackgrounds(JollyRogerElement[] elements) {
        this.backgrounds = elements;
    }

    public boolean addBackground(JollyRogerElement bg) {
        for (int i = 0; i < this.backgrounds.length; ++i) {
            JollyRogerElement background = this.backgrounds[i];
            if (background != null) continue;
            this.backgrounds[i] = bg;
            return true;
        }
        return false;
    }

    public boolean setBackground(int slot, JollyRogerElement bg) {
        if (!this.hasBackground(bg) && slot <= 2) {
            this.backgrounds[slot] = bg;
            return true;
        }
        return false;
    }

    public boolean hasBackground(JollyRogerElement bg) {
        return ((Stream)Arrays.stream(this.backgrounds).parallel()).anyMatch(background -> background != null && background.equals((Object)bg));
    }

    public JollyRogerElement[] getDetails() {
        return this.details;
    }

    public void setDetails(JollyRogerElement[] elements) {
        this.details = elements;
    }

    public boolean addDetail(JollyRogerElement det) {
        for (int i = 0; i < this.details.length; ++i) {
            JollyRogerElement detail = this.details[i];
            if (detail != null) continue;
            this.details[i] = det;
            return true;
        }
        return false;
    }

    public boolean setDetail(int slot, JollyRogerElement det) {
        if (!this.hasDetail(det) && slot <= 5) {
            this.details[slot] = det;
            return true;
        }
        return false;
    }

    public boolean hasDetail(JollyRogerElement det) {
        return ((Stream)Arrays.stream(this.details).parallel()).anyMatch(detail -> detail != null && detail.equals((Object)det));
    }
}

