/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.commands;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import xyz.pixelatedw.mineminenomi.api.events.LoyaltyEvent;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.packets.server.SSyncEntityStatsPacket;
import xyz.pixelatedw.mineminenomi.wypi.network.WyNetwork;

public class LoyaltyCommand {
    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.func_197057_a((String)"loyalty").requires(source -> source.func_197034_c(2));
        int min = -100;
        int max = 100;
        builder.then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)min, (int)max)).executes(context -> LoyaltyCommand.alterLoyalty((CommandContext<CommandSource>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"amount"), LoyaltyCommand.getDefaultCollection((CommandContext<CommandSource>)context)))).then(Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197094_d()).executes(context -> LoyaltyCommand.alterLoyalty((CommandContext<CommandSource>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"amount"), EntityArgument.func_197090_e((CommandContext)context, (String)"targets")))));
        dispatcher.register(builder);
    }

    private static Collection<ServerPlayerEntity> getDefaultCollection(CommandContext<CommandSource> context) throws CommandSyntaxException {
        return Lists.newArrayList((Object[])new ServerPlayerEntity[]{((CommandSource)context.getSource()).func_197035_h()});
    }

    private static int alterLoyalty(CommandContext<CommandSource> context, int amount, Collection<ServerPlayerEntity> targets) throws CommandSyntaxException {
        for (ServerPlayerEntity player : targets) {
            IEntityStats entityStatsProps = EntityStatsCapability.get((LivingEntity)player);
            entityStatsProps.alterLoyalty(amount);
            WyNetwork.sendTo(new SSyncEntityStatsPacket(player.func_145782_y(), entityStatsProps), (PlayerEntity)player);
            LoyaltyEvent e = new LoyaltyEvent((PlayerEntity)player, amount);
            MinecraftForge.EVENT_BUS.post((Event)e);
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "" + (amount > 0 ? "+" : "") + amount + " loyalty for " + player.func_145748_c_().func_150254_d()), true);
        }
        return 1;
    }
}

