/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.data.entity.quests;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import xyz.pixelatedw.mineminenomi.api.quests.Quest;
import xyz.pixelatedw.mineminenomi.api.quests.objectives.Objective;
import xyz.pixelatedw.mineminenomi.data.entity.quests.IQuestData;

public class QuestDataBase
implements IQuestData {
    private Quest[] inProgressQuests = new Quest[4];
    private List<Quest> finishedQuests = new ArrayList<Quest>();

    @Override
    public boolean addInProgressQuest(Quest quest) {
        for (int i = 0; i < this.inProgressQuests.length; ++i) {
            Quest ogQuest = this.inProgressQuests[i];
            if (ogQuest != null) continue;
            this.inProgressQuests[i] = quest;
            return true;
        }
        return false;
    }

    @Override
    public boolean setInProgressQuest(int slot, Quest quest) {
        Quest ogQuest = this.getInProgressQuest(quest);
        if (ogQuest == null && slot <= 4) {
            this.inProgressQuests[slot] = quest;
            return true;
        }
        return false;
    }

    @Override
    public boolean removeInProgressQuest(Quest quest) {
        Quest ogQuest = this.getInProgressQuest(quest);
        if (ogQuest != null) {
            for (int i = 0; i < this.inProgressQuests.length; ++i) {
                Quest inProgressQuest = this.inProgressQuests[i];
                if (inProgressQuest == null || !inProgressQuest.equals((Object)ogQuest)) continue;
                this.inProgressQuests[i] = null;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasInProgressQuest(Quest quest) {
        return ((Stream)Arrays.stream(this.inProgressQuests).parallel()).filter(qst -> qst != null).anyMatch(qst -> qst.equals((Object)quest));
    }

    @Override
    public <T extends Quest> T getInProgressQuest(T quest) {
        return (T)((Object)((Quest)((Stream)Arrays.stream(this.inProgressQuests).parallel()).filter(qst -> qst != null).filter(qst -> qst.equals((Object)quest)).findFirst().orElse(null)));
    }

    @Override
    public <T extends Quest> T getInProgressQuest(int slot) {
        return (T)((Object)this.inProgressQuests[slot]);
    }

    @Override
    public int getInProgressQuestSlot(Quest quest) {
        for (int i = 0; i < this.inProgressQuests.length; ++i) {
            if (!this.inProgressQuests[i].equals((Object)quest)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public List<Objective> getInProgressObjectives() {
        ArrayList<Objective> objectives = new ArrayList<Objective>();
        for (Quest quest : this.getInProgressQuests()) {
            if (quest == null || quest.isComplete()) continue;
            for (Objective obj : quest.getObjectives()) {
                if (obj.isHidden() || obj.isLocked() || obj.isComplete()) continue;
                objectives.add(obj);
            }
        }
        return objectives;
    }

    @Override
    public Quest[] getInProgressQuests() {
        return this.inProgressQuests;
    }

    @Override
    public void clearInProgressQuests() {
        for (int i = 0; i < this.inProgressQuests.length; ++i) {
            Quest quest = this.inProgressQuests[i];
            if (quest == null) continue;
            this.inProgressQuests[i] = null;
        }
    }

    @Override
    public int countInProgressQuests() {
        return ((Stream)Arrays.stream(this.inProgressQuests).parallel()).filter(quest -> quest != null).collect(Collectors.toList()).size();
    }

    @Override
    public boolean addFinishedQuest(Quest quest) {
        Quest ogQuest = this.getFinishedQuest(quest);
        if (ogQuest == null) {
            this.finishedQuests.add(quest);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeFinishedQuest(Quest quest) {
        Quest ogQuest = this.getFinishedQuest(quest);
        if (ogQuest != null) {
            this.finishedQuests.remove((Object)ogQuest);
            return true;
        }
        return false;
    }

    @Override
    public boolean hasFinishedQuest(Quest quest) {
        this.finishedQuests.removeIf(qst -> qst == null);
        return this.finishedQuests.parallelStream().anyMatch(qst -> qst.equals((Object)quest));
    }

    @Override
    public <T extends Quest> T getFinishedQuest(T quest) {
        this.finishedQuests.removeIf(qst -> qst == null);
        return (T)((Object)((Quest)this.finishedQuests.parallelStream().filter(qst -> qst.equals((Object)quest)).findFirst().orElse(null)));
    }

    @Override
    public List<Quest> getFinishedQuests() {
        this.finishedQuests.removeIf(qst -> qst == null);
        return this.finishedQuests.parallelStream().collect(Collectors.toList());
    }

    @Override
    public void clearFinishedQuests() {
        this.finishedQuests.removeIf(qst -> qst == null);
    }

    @Override
    public int countFinishedQuests() {
        this.finishedQuests.removeIf(qst -> qst == null);
        return this.finishedQuests.size();
    }
}

