/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.data.world;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.WorldSavedData;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.crew.Crew;
import xyz.pixelatedw.mineminenomi.api.crew.JollyRoger;
import xyz.pixelatedw.mineminenomi.api.helpers.DevilFruitHelper;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.items.AkumaNoMiItem;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class ExtendedWorldData
extends WorldSavedData {
    private static final String IDENTIFIER = "mineminenomi";
    private HashMap<String, Long> issuedBounties = new HashMap();
    private List<String> devilFruitsInWorld = new ArrayList<String>();
    private List<int[][]> abilityProtections = new ArrayList<int[][]>();
    private HashMap<String, Crew> pirateCrews = new HashMap();
    private HashMap<UUID, String> ateDevilFruits = new HashMap();
    private HashMap<UUID, List<String>> devilFruitsInInventories = new HashMap();
    private HashMap<UUID, Pair<Date, List<String>>> loggedoutFruits = new HashMap();
    private List<String> generatedArenas = new ArrayList<String>();
    private static final ExtendedWorldData CLIENT_DATA = new ExtendedWorldData();

    public ExtendedWorldData() {
        super(IDENTIFIER);
    }

    public ExtendedWorldData(String identifier) {
        super(identifier);
    }

    public static ExtendedWorldData get(World world) {
        if (world == null) {
            return null;
        }
        ExtendedWorldData worldExt = null;
        if (world instanceof ServerWorld) {
            ServerWorld serverWorld = world.func_73046_m().func_71218_a(DimensionType.field_223227_a_);
            worldExt = (ExtendedWorldData)serverWorld.func_217481_x().func_215752_a(ExtendedWorldData::new, IDENTIFIER);
        } else {
            worldExt = CLIENT_DATA;
        }
        return worldExt;
    }

    public void func_76184_a(CompoundNBT nbt) {
        CompoundNBT bounties = nbt.func_74775_l("issuedBounties");
        this.issuedBounties.clear();
        bounties.func_150296_c().stream().forEach(x -> this.issuedBounties.put((String)x, bounties.func_74763_f(x)));
        CompoundNBT devilFruits = nbt.func_74775_l("devilFruits");
        this.devilFruitsInWorld.clear();
        devilFruits.func_150296_c().stream().forEach(x -> this.devilFruitsInWorld.add((String)x));
        CompoundNBT protectedAreas = nbt.func_74775_l("protectedAreas");
        this.abilityProtections.clear();
        for (int i = 0; i <= protectedAreas.func_150296_c().size(); ++i) {
            int[] minPos = protectedAreas.func_74759_k("minPos_" + i);
            int[] maxPos = protectedAreas.func_74759_k("maxPos_" + i);
            if (minPos.length != 3 || maxPos.length != 3) continue;
            this.abilityProtections.add(new int[][]{minPos, maxPos});
        }
        this.pirateCrews.clear();
        ListNBT crews = nbt.func_150295_c("crews", 10);
        for (int i = 0; i < crews.size(); ++i) {
            CompoundNBT crewNBT = crews.func_150305_b(i);
            Crew crew = new Crew();
            crew.read(crewNBT);
            this.pirateCrews.put(WyHelper.getResourceName(crew.getName()), crew);
        }
        CompoundNBT ateDevilFruits = nbt.func_74775_l("ateDevilFruits");
        this.ateDevilFruits.clear();
        ateDevilFruits.func_150296_c().stream().forEach(key -> this.ateDevilFruits.put(UUID.fromString(key), ateDevilFruits.func_74779_i(key)));
        this.devilFruitsInInventories.clear();
        ListNBT dfInInventories = nbt.func_150295_c("devilFruitsInInventories", 10);
        for (int i = 0; i < dfInInventories.size(); ++i) {
            CompoundNBT invNbt = dfInInventories.func_150305_b(i);
            ArrayList<String> fruits = new ArrayList<String>();
            int noFruits = invNbt.func_74762_e("fruits");
            for (int j = 0; j < noFruits; ++j) {
                fruits.add(invNbt.func_74779_i("fruit-" + j));
            }
            this.devilFruitsInInventories.put(invNbt.func_186857_a("uuid"), fruits);
        }
        this.loggedoutFruits.clear();
        ListNBT loggedoutFruits = nbt.func_150295_c("loggedoutFruits", 10);
        for (int i = 0; i < loggedoutFruits.size(); ++i) {
            CompoundNBT nbtData = loggedoutFruits.func_150305_b(i);
            UUID id = nbtData.func_186857_a("uuid");
            Date date = new Date(nbtData.func_74763_f("date"));
            ArrayList<String> fruits = new ArrayList<String>();
            int noFruits = nbtData.func_74762_e("fruits");
            for (int j = 0; j < noFruits; ++j) {
                fruits.add(nbtData.func_74779_i("fruit-" + j));
            }
            this.loggedoutFruits.put(id, (Pair<Date, List<String>>)ImmutablePair.of((Object)date, fruits));
        }
        CompoundNBT generatedArenas = nbt.func_74775_l("generatedArenas");
        this.generatedArenas.clear();
        generatedArenas.func_150296_c().stream().forEach(key -> this.generatedArenas.add((String)key));
    }

    public CompoundNBT func_189551_b(CompoundNBT nbt) {
        CompoundNBT bounties = new CompoundNBT();
        if (this.issuedBounties.size() > 0) {
            this.issuedBounties.entrySet().stream().forEach(x -> bounties.func_74772_a((String)x.getKey(), ((Long)x.getValue()).longValue()));
        }
        nbt.func_218657_a("issuedBounties", (INBT)bounties);
        CompoundNBT devilFruits = new CompoundNBT();
        if (this.devilFruitsInWorld.size() > 0) {
            this.devilFruitsInWorld.stream().forEach(x -> devilFruits.func_74757_a(x, true));
        }
        nbt.func_218657_a("devilFruits", (INBT)devilFruits);
        CompoundNBT protectedAreas = new CompoundNBT();
        if (this.abilityProtections.size() > 0) {
            int i = 0;
            for (int[][] nArray : this.abilityProtections) {
                protectedAreas.func_74783_a("minPos_" + i, nArray[0]);
                protectedAreas.func_74783_a("maxPos_" + i, nArray[1]);
                ++i;
            }
        }
        nbt.func_218657_a("protectedAreas", (INBT)protectedAreas);
        ListNBT crews = new ListNBT();
        for (Crew crew : this.pirateCrews.values()) {
            crews.add((Object)crew.write());
        }
        nbt.func_218657_a("crews", (INBT)crews);
        CompoundNBT ateDevilFruits = new CompoundNBT();
        if (this.ateDevilFruits.size() > 0) {
            for (Map.Entry<UUID, String> entry : this.ateDevilFruits.entrySet()) {
                ateDevilFruits.func_74778_a(entry.getKey().toString(), entry.getValue());
            }
        }
        nbt.func_218657_a("ateDevilFruits", (INBT)ateDevilFruits);
        ListNBT listNBT = new ListNBT();
        for (Map.Entry<UUID, List<String>> entry : this.devilFruitsInInventories.entrySet()) {
            CompoundNBT compoundNBT = new CompoundNBT();
            compoundNBT.func_186854_a("uuid", entry.getKey());
            int i = 0;
            for (String fruit : entry.getValue()) {
                compoundNBT.func_74778_a("fruit-" + i, fruit);
                ++i;
            }
            compoundNBT.func_74768_a("fruits", i);
            listNBT.add((Object)compoundNBT);
        }
        nbt.func_218657_a("devilFruitsInInventories", (INBT)listNBT);
        ListNBT listNBT2 = new ListNBT();
        for (Map.Entry<UUID, Pair<Date, List<String>>> entry : this.loggedoutFruits.entrySet()) {
            CompoundNBT nbtData = new CompoundNBT();
            nbtData.func_186854_a("uuid", entry.getKey());
            nbtData.func_74772_a("date", ((Date)entry.getValue().getKey()).getTime());
            int i = 0;
            for (String fruit : (List)entry.getValue().getValue()) {
                nbtData.func_74778_a("fruit-" + i, fruit);
                ++i;
            }
            nbtData.func_74768_a("fruits", i);
            listNBT2.add((Object)nbtData);
        }
        nbt.func_218657_a("loggedoutFruits", (INBT)listNBT2);
        CompoundNBT compoundNBT = new CompoundNBT();
        if (this.generatedArenas.size() > 0) {
            for (String key : this.generatedArenas) {
                compoundNBT.func_74757_a(key, true);
            }
        }
        nbt.func_218657_a("generatedArenas", (INBT)compoundNBT);
        return nbt;
    }

    public boolean isArenaGenerated(String key) {
        return this.generatedArenas.contains(key);
    }

    public List<String> getGeneratedArenas() {
        return this.generatedArenas;
    }

    public void removeGeneratedArena(String key) {
        this.generatedArenas.remove(key);
        this.func_76185_a();
    }

    public void addGeneratedArena(String key) {
        this.generatedArenas.add(key);
        this.func_76185_a();
    }

    public HashMap<UUID, String> getAteFruits() {
        return this.ateDevilFruits;
    }

    public void addAteDevilFruit(PlayerEntity player, AkumaNoMiItem df) {
        String key = DevilFruitHelper.getDevilFruitKey(df);
        this.addAteDevilFruit(player, key);
    }

    public void addAteDevilFruit(PlayerEntity player, String key) {
        if (this.ateDevilFruits.containsKey(player.func_110124_au())) {
            return;
        }
        this.ateDevilFruits.put(player.func_110124_au(), key);
        this.func_76185_a();
    }

    public void removeAteDevilFruit(UUID uuid) {
        this.ateDevilFruits.remove(uuid);
        this.func_76185_a();
    }

    public void removeAteDevilFruit(PlayerEntity player) {
        this.ateDevilFruits.remove(player.func_110124_au());
        this.func_76185_a();
    }

    public List<Crew> getCrews() {
        return new ArrayList<Crew>(this.pirateCrews.values());
    }

    @Nullable
    public Crew getCrewWithMember(UUID memId) {
        for (Crew crew : this.pirateCrews.values()) {
            for (Crew.Member member : crew.getMembers()) {
                if (!member.getUUID().equals(memId)) continue;
                return crew;
            }
        }
        return null;
    }

    @Nullable
    public Crew getCrewWithCaptain(UUID capId) {
        return this.pirateCrews.values().stream().filter(crew -> crew.getCaptain() != null && crew.getCaptain().getUUID().equals(capId)).findFirst().orElse(null);
    }

    public void removeCrew(Crew crew) {
        String key = WyHelper.getResourceName(crew.getName());
        if (this.pirateCrews.containsKey(key)) {
            this.pirateCrews.remove(key);
        }
        this.func_76185_a();
    }

    public void addCrew(Crew crew) {
        String key = WyHelper.getResourceName(crew.getName());
        if (!this.pirateCrews.containsKey(key)) {
            this.pirateCrews.put(key, crew);
        }
        this.func_76185_a();
    }

    public void removeCrewMember(Crew crew, UUID uuid) {
        crew.removeMember(uuid);
        this.func_76185_a();
    }

    public void addCrewMember(Crew crew, LivingEntity entity) {
        crew.addMember(entity);
        this.func_76185_a();
    }

    public void updateCrewJollyRoger(Crew crew, JollyRoger jollyRoger) {
        crew.setJollyRoger(jollyRoger);
        this.func_76185_a();
    }

    public boolean isInsideRestrictedArea(int posX, int posY, int posZ) {
        if (this.abilityProtections.size() <= 0) {
            return false;
        }
        for (int[][] area : this.abilityProtections) {
            int[] minPos = area[0];
            int[] maxPos = area[1];
            if (minPos.length <= 0 || maxPos.length <= 0 || posX <= minPos[0] || posX >= maxPos[0] || posY <= minPos[1] || posY >= maxPos[1] || posZ <= minPos[2] || posZ >= maxPos[2]) continue;
            return true;
        }
        return false;
    }

    public void addRestrictedArea(int[] minPos, int[] maxPos) {
        this.abilityProtections.add(new int[][]{minPos, maxPos});
        this.func_76185_a();
    }

    public void removeRestrictedArea(int id) {
        this.abilityProtections.remove(id);
        this.func_76185_a();
    }

    public void resizeRestrictedArea(int id, int[] minPos, int[] maxPos) {
        this.abilityProtections.set(id, new int[][]{minPos, maxPos});
        this.func_76185_a();
    }

    public void removeRestrictedArea(int midX, int midY, int midZ) {
        Iterator<int[][]> iterator = this.abilityProtections.iterator();
        while (iterator.hasNext()) {
            int[][] area = iterator.next();
            int[] minPos = area[0];
            int[] maxPos = area[1];
            if (minPos.length <= 0 || maxPos.length <= 0) continue;
            int possibleMidX = (minPos[0] + maxPos[0]) / 2;
            int possibleMidY = (minPos[1] + maxPos[1]) / 2;
            int possibleMidZ = (minPos[2] + maxPos[2]) / 2;
            if (midX != possibleMidX || midY != possibleMidY || midZ != possibleMidZ) continue;
            iterator.remove();
        }
        this.func_76185_a();
    }

    public List<int[][]> getAllRestrictions() {
        return this.abilityProtections;
    }

    public HashMap<String, Long> getAllBounties() {
        return this.issuedBounties;
    }

    public Object[] getRandomBounty() {
        int count = this.getAllBounties().size();
        if (count <= 0) {
            return null;
        }
        Object[] keys = this.getAllBounties().keySet().toArray();
        Object key = keys[new Random().nextInt(count)];
        long bounty = this.getAllBounties().get(key);
        return new Object[]{key, bounty};
    }

    public long getBounty(String uuid) {
        if (this.issuedBounties.containsKey(uuid.toLowerCase())) {
            return this.issuedBounties.get(uuid.toLowerCase());
        }
        return 0L;
    }

    public void issueBounty(String uuid, long bounty) {
        if (this.issuedBounties.containsKey(uuid.toLowerCase())) {
            this.issuedBounties.remove(uuid.toLowerCase());
            this.issuedBounties.put(uuid.toLowerCase(), bounty);
        } else {
            this.issuedBounties.put(uuid.toLowerCase(), bounty);
        }
        this.func_76185_a();
    }

    public List<String> getDevilFruitsInWorld() {
        return this.devilFruitsInWorld;
    }

    public void removeDevilFruitInWorld(AkumaNoMiItem fruit) {
        String name = DevilFruitHelper.getDevilFruitKey(fruit);
        this.removeDevilFruitInWorld(name);
    }

    public void removeDevilFruitInWorld(String name) {
        if (this.devilFruitsInWorld.contains(name)) {
            this.devilFruitsInWorld.remove(name);
            this.func_76185_a();
        }
    }

    public void removeDevilFruitsInWorld(List<String> names) {
        this.devilFruitsInWorld.removeAll(names);
        this.func_76185_a();
    }

    public void addDevilFruitInWorld(AkumaNoMiItem fruit) {
        String name = DevilFruitHelper.getDevilFruitKey(fruit);
        this.addDevilFruitInWorld(name);
    }

    public void addDevilFruitInWorld(String name) {
        if (!CommonConfig.INSTANCE.hasOneFruitPerWorldSimpleLogic()) {
            return;
        }
        if (!this.devilFruitsInWorld.contains(name)) {
            this.devilFruitsInWorld.add(name);
            this.func_76185_a();
        }
    }

    public boolean isDevilFruitInWorld(AkumaNoMiItem fruit) {
        String key = DevilFruitHelper.getDevilFruitKey(fruit);
        return this.devilFruitsInWorld.contains(key);
    }

    public boolean isDevilFruitInWorld(String name) {
        return this.devilFruitsInWorld.contains(name);
    }

    public void addDevilFruitInInventory(UUID playerId, String fruit) {
        if (!CommonConfig.INSTANCE.hasOneFruitPerWorldSimpleLogic()) {
            return;
        }
        if (this.devilFruitsInInventories.containsKey(playerId)) {
            if (!this.devilFruitsInInventories.get(playerId).contains(fruit)) {
                this.devilFruitsInInventories.get(playerId).add(fruit);
            }
        } else {
            ArrayList<String> fruits = new ArrayList<String>();
            fruits.add(fruit);
            this.devilFruitsInInventories.put(playerId, fruits);
        }
        this.func_76185_a();
    }

    public void removeDevilFruitInInventory(UUID playerId, String fruit) {
        if (!CommonConfig.INSTANCE.hasOneFruitPerWorldSimpleLogic()) {
            return;
        }
        if (this.devilFruitsInInventories.containsKey(playerId)) {
            this.devilFruitsInInventories.get(playerId).remove(fruit);
            this.func_76185_a();
        }
    }

    public void removeDevilFruitsInInventory(UUID playerId, List<String> fruits) {
        if (!CommonConfig.INSTANCE.hasOneFruitPerWorldSimpleLogic()) {
            return;
        }
        this.devilFruitsInInventories.get(playerId).removeAll(fruits);
        this.func_76185_a();
    }

    public List<String> getFruitsInPlayerInventory(UUID playerId) {
        return this.devilFruitsInInventories.get(playerId);
    }

    public HashMap<UUID, List<String>> getFruitsInInventory() {
        return this.devilFruitsInInventories;
    }

    public HashMap<UUID, Pair<Date, List<String>>> getLoggedOutDevilFruits() {
        return this.loggedoutFruits;
    }

    @Nullable
    public Pair<Date, List<String>> getLoggedOutPlayer(UUID uuid) {
        if (this.loggedoutFruits.containsKey(uuid)) {
            return this.loggedoutFruits.get(uuid);
        }
        return null;
    }

    public void addLoggedOutFruit(UUID playerId, List<String> fruits) {
        if (!CommonConfig.INSTANCE.hasOneFruitPerWorldSimpleLogic()) {
            return;
        }
        this.loggedoutFruits.put(playerId, (Pair<Date, List<String>>)ImmutablePair.of((Object)new Date(), fruits));
        this.func_76185_a();
    }

    public void removeLoggedOutFruit(UUID playerId) {
        if (!CommonConfig.INSTANCE.hasOneFruitPerWorldSimpleLogic()) {
            return;
        }
        this.loggedoutFruits.remove(playerId);
        this.func_76185_a();
    }
}

