/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities;

import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.potion.EffectInstance;
import xyz.pixelatedw.mineminenomi.entities.mobs.OPEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.CooldownGoal;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class BlockGoal
extends CooldownGoal {
    private OPEntity entity;
    private int hitCount;
    private int maxCount;
    private int duration;
    private int maxDuration;
    private int randomizer;
    private float prevHealth;
    private UUID armorUuid = UUID.fromString("89a306f5-3d73-40ba-9332-c30fd88c204a");
    private AttributeModifier armorModifier = new AttributeModifier(this.armorUuid, "Armor Bonus", 2.5, AttributeModifier.Operation.MULTIPLY_TOTAL);

    public BlockGoal(OPEntity entity) {
        this(entity, 2, 3);
        this.entity.addThreat(1);
    }

    public BlockGoal(OPEntity entity, int duration, int hitCount) {
        this(entity, duration, hitCount, 3);
    }

    public BlockGoal(OPEntity entity, int duration, int hitCount, int random) {
        super(entity, 30, (int)WyHelper.randomWithRange(5, 10));
        this.entity = entity;
        this.maxDuration = duration;
        this.maxCount = hitCount;
        this.prevHealth = this.entity.func_110143_aJ();
        this.randomizer = random;
        this.entity.addThreat(1);
    }

    @Override
    public boolean func_75250_a() {
        float distance;
        if (!super.func_75250_a()) {
            return false;
        }
        if (this.entity.func_70638_az() == null) {
            return false;
        }
        if (this.entity.func_110143_aJ() < this.prevHealth) {
            ++this.hitCount;
            this.prevHealth = this.entity.func_110143_aJ();
        }
        if ((distance = this.entity.func_70032_d((Entity)this.entity.func_70638_az())) > 3.0f) {
            return false;
        }
        return this.hitCount >= this.maxCount;
    }

    @Override
    public void endCooldown() {
        super.endCooldown();
        this.entity.setCurrentGoal(null);
        this.entity.setPreviousGoal(this);
        this.duration = 0;
    }

    public void func_75249_e() {
        this.entity.setAnimation(OPEntity.Animation.BLOCK.ordinal());
        if (this.entity.func_70644_a(ModEffects.MOVEMENT_BLOCKED)) {
            this.entity.func_195063_d(ModEffects.MOVEMENT_BLOCKED);
        }
        this.entity.func_195064_c(new EffectInstance(ModEffects.MOVEMENT_BLOCKED, this.maxDuration, 0, false, false));
        IAttributeInstance attr = this.entity.func_110148_a(SharedMonsterAttributes.field_188791_g);
        if (attr.func_180374_a(this.armorModifier)) {
            attr.func_188479_b(this.armorUuid);
        }
        attr.func_111121_a(this.armorModifier);
    }

    public boolean func_75253_b() {
        ++this.duration;
        boolean continueExecution = false;
        if (this.duration < this.maxDuration) {
            continueExecution = true;
        }
        if (!continueExecution) {
            this.entity.setAnimation(OPEntity.Animation.NONE.ordinal());
            this.hitCount = 0;
            this.maxCount = (int)WyHelper.randomWithRange(0, this.randomizer);
            this.entity.setCurrentGoal(this);
            this.setOnCooldown(true);
        }
        return continueExecution;
    }
}

