/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.mobs.pirates;

import java.util.function.Predicate;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.OpenDoorGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.potion.Effects;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.World;
import xyz.pixelatedw.mineminenomi.api.helpers.FactionHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.entities.mobs.OPEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.ImprovedHurtByTargetGoal;
import xyz.pixelatedw.mineminenomi.init.ModArmors;
import xyz.pixelatedw.mineminenomi.init.ModWeapons;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public abstract class AbstractPirateEntity
extends OPEntity {
    protected static final Item[] PIRATE_SWORDS = new Item[]{ModWeapons.PIRATE_CUTLASS, Items.field_151040_l, Items.field_151052_q, Items.field_151049_t, Items.field_151036_c};
    private static final DataParameter<String> CREW = EntityDataManager.func_187226_a(AbstractPirateEntity.class, (IDataSerializer)DataSerializers.field_187194_d);

    protected AbstractPirateEntity(EntityType<? extends MobEntity> type, World world) {
        this(type, world, (String[])null);
    }

    protected AbstractPirateEntity(EntityType<? extends MobEntity> type, World world, String[] textures) {
        super(type, world, textures);
    }

    protected void func_184651_r() {
        IEntityStats props = EntityStatsCapability.get((LivingEntity)this);
        props.setFaction("pirate");
        if (this.field_70170_p.func_201674_k().nextInt(10) < 3) {
            props.setRace("fishman");
            this.queueEntityDataUpdate();
        }
        ((GroundPathNavigator)this.func_70661_as()).func_179688_b(true);
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(0, (Goal)new OpenDoorGoal((MobEntity)this, true));
        this.field_70714_bg.func_75776_a(2, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.8));
        this.field_70714_bg.func_75776_a(3, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(3, (Goal)new LookRandomlyGoal((MobEntity)this));
        Predicate<Entity> factionScope = FactionHelper.getOutsideGroupPredicate((LivingEntity)this);
        Predicate<Entity> invisibleEntity = entity -> {
            if (entity instanceof LivingEntity) {
                return !((LivingEntity)entity).func_70644_a(Effects.field_76441_p);
            }
            return false;
        };
        this.field_70715_bh.func_75776_a(1, (Goal)new ImprovedHurtByTargetGoal(this, factionScope, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, OPEntity.class, 10, true, false, factionScope.and(invisibleEntity)));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, 10, true, false, factionScope.and(invisibleEntity)));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, MonsterEntity.class, true, true));
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(CREW, (Object)"");
    }

    @Override
    public void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        nbt.func_74778_a("crew", this.getCrew());
    }

    @Override
    public void func_70037_a(CompoundNBT nbt) {
        super.func_70037_a(nbt);
        this.setCrew(nbt.func_74779_i("crew"));
    }

    protected boolean func_225511_J_() {
        return true;
    }

    @Override
    public boolean func_213397_c(double distance) {
        return distance > 1024.0;
    }

    public String getCrew() {
        return (String)this.func_184212_Q().func_187225_a(CREW);
    }

    public void setCrew(String crew) {
        this.func_184212_Q().func_187227_b(CREW, (Object)crew);
    }

    protected void func_213337_cE() {
        super.func_213337_cE();
        if (this.func_184582_a(EquipmentSlotType.HEAD).func_77973_b() == ModArmors.MH5_GAS_MASK && WyHelper.randomDouble() < 0.2) {
            this.func_199703_a((IItemProvider)ModArmors.MH5_GAS_MASK);
        }
    }
}

