/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.projectiles.hie;

import java.util.List;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import xyz.pixelatedw.mineminenomi.abilities.hie.IceAgeAbility;
import xyz.pixelatedw.mineminenomi.entities.projectiles.hie.HieProjectiles;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.projectiles.AbilityProjectileEntity;

public class IceBlockAvalancheProjectile
extends AbilityProjectileEntity {
    private static final DataParameter<Boolean> FINALIZED = EntityDataManager.func_187226_a(IceBlockAvalancheProjectile.class, (IDataSerializer)DataSerializers.field_187198_h);

    public IceBlockAvalancheProjectile(World world) {
        super(HieProjectiles.ICE_BLOCK_AVALANCHE, world);
    }

    public IceBlockAvalancheProjectile(EntityType type, World world) {
        super(type, world);
    }

    public IceBlockAvalancheProjectile(World world, double x, double y, double z) {
        super(HieProjectiles.ICE_BLOCK_AVALANCHE, world, x, y, z);
    }

    public IceBlockAvalancheProjectile(World world, LivingEntity player) {
        super(HieProjectiles.ICE_BLOCK_AVALANCHE, world, player);
        this.setDamage(40.0f);
        this.setMaxLife(150);
        this.setPhysical(false);
        this.setPassThroughEntities();
        this.setCanGetStuckInGround();
        this.onTickEvent = this::onTickEvent;
        this.withEffects = () -> new EffectInstance[]{new EffectInstance(ModEffects.FROZEN, 200, 0), new EffectInstance(Effects.field_76419_f, 100, 1)};
        this.onEntityImpactEvent = this::onEntityImpactEvent;
        this.onBlockImpactEvent = this::onBlockImpactEvent;
    }

    private void onTickEvent() {
        if (!this.getFinalized()) {
            this.setCollisionSize(this.field_70173_aa / 10);
            if (this.field_70173_aa > 60) {
                this.setFinalized(true);
            }
        }
        if (this.isStuckInGround()) {
            this.func_213293_j(0.0, 0.0, 0.0);
        }
    }

    @Override
    public void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(FINALIZED, (Object)false);
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("finalized", this.getFinalized());
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.field_70180_af.func_187227_b(FINALIZED, (Object)compound.func_74767_n("finalized"));
    }

    public void setFinalized(boolean val) {
        this.field_70180_af.func_187227_b(FINALIZED, (Object)val);
    }

    public boolean getFinalized() {
        return (Boolean)this.field_70180_af.func_187225_a(FINALIZED);
    }

    public void onEntityImpactEvent(LivingEntity entity) {
        List<LivingEntity> targets = WyHelper.getEntitiesNear(this.func_180425_c(), this.field_70170_p, this.getCollisionSize());
        for (LivingEntity target : targets) {
            Vec3d speed = WyHelper.propulsion(target, 1.0, 1.0);
            target.func_213293_j(-speed.field_72450_a, 0.5, -speed.field_72449_c);
            target.func_70097_a(this.source, this.getDamage() * 0.75f);
            this.triggerEffects(target);
        }
        this.onBlockImpactEvent.onImpact(entity.func_180425_c());
    }

    public void onBlockImpactEvent(BlockPos pos) {
        this.setCollisionSize(0.0);
        this.func_213293_j(0.0, 0.0, 0.0);
        if (!this.field_70170_p.field_72995_K) {
            IceAgeAbility.PARTICLES.spawn(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 0.0, 0.0, 0.0);
        }
    }
}

