/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.projectiles.ito;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import xyz.pixelatedw.mineminenomi.api.abilities.ExplosionAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.ito.ItoProjectiles;
import xyz.pixelatedw.mineminenomi.wypi.abilities.events.SetOnFireEvent;
import xyz.pixelatedw.mineminenomi.wypi.abilities.projectiles.AbilityProjectileEntity;

public class OverheatProjectile
extends AbilityProjectileEntity {
    public OverheatProjectile(World world) {
        super(ItoProjectiles.OVERHEAT, world);
    }

    public OverheatProjectile(EntityType type, World world) {
        super(type, world);
    }

    public OverheatProjectile(World world, double x, double y, double z) {
        super(ItoProjectiles.OVERHEAT, world, x, y, z);
    }

    public OverheatProjectile(World world, LivingEntity player) {
        super(ItoProjectiles.OVERHEAT, world, player);
        this.setDamage(20.0f);
        this.setPassThroughEntities();
        this.setPhysical(false);
        this.setAffectedByImbuing();
        this.onEntityImpactEvent = this::onEntityImpactEvent;
        this.onBlockImpactEvent = this::onBlockImpactEvent;
    }

    private void onEntityImpactEvent(LivingEntity hitEntity) {
        this.onBlockImpactEvent.onImpact(hitEntity.func_180425_c());
        SetOnFireEvent event = new SetOnFireEvent(this.func_85052_h(), hitEntity, 10);
        if (!MinecraftForge.EVENT_BUS.post((Event)event)) {
            hitEntity.func_70015_d(10);
        }
    }

    private void onBlockImpactEvent(BlockPos hit) {
        ExplosionAbility explosion = AbilityHelper.newExplosion((Entity)this.func_85052_h(), this.field_70170_p, hit.func_177958_n(), hit.func_177956_o(), hit.func_177952_p(), 4.0f);
        explosion.setStaticDamage(20.0f);
        explosion.setExplosionSound(true);
        explosion.setDamageOwner(false);
        explosion.setDestroyBlocks(true);
        explosion.setFireAfterExplosion(true);
        explosion.setSmokeParticles(null);
        explosion.setDamageEntities(true);
        explosion.doExplosion();
    }
}

