/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.projectiles.mera;

import java.util.List;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.api.abilities.ExplosionAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.protection.BlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.block.LiquidBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.block.SnowLayerBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.entities.projectiles.mera.MeraProjectiles;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModParticleTypes;
import xyz.pixelatedw.mineminenomi.particles.data.GenericParticleData;
import xyz.pixelatedw.mineminenomi.particles.effects.common.CommonExplosionParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.wypi.abilities.projectiles.IFlexibleSizeProjectile;

public class DaiEnkaiEnteiProjectile
extends AbilityProjectileEntity
implements IFlexibleSizeProjectile {
    private static final BlockProtectionRule GRIEF_RULE = new BlockProtectionRule(LiquidBlockProtectionRule.INSTANCE, SnowLayerBlockProtectionRule.INSTANCE);

    public DaiEnkaiEnteiProjectile(World world) {
        super(MeraProjectiles.DAI_ENKAI_ENTEI, world);
    }

    public DaiEnkaiEnteiProjectile(EntityType type, World world) {
        super(type, world);
    }

    public DaiEnkaiEnteiProjectile(World world, double x, double y, double z) {
        super(MeraProjectiles.DAI_ENKAI_ENTEI, world, x, y, z);
    }

    public DaiEnkaiEnteiProjectile(World world, LivingEntity player) {
        super(MeraProjectiles.DAI_ENKAI_ENTEI, world, player);
        this.setDamage(80.0f);
        this.setDamageSource(ModDamageSource.FIRE.causeIndirectDamageFromSource(this));
        this.onBlockImpactEvent = this::onBlockImpactEvent;
        this.onTickEvent = this::onTickEvent;
    }

    private void onBlockImpactEvent(BlockPos hit) {
        ExplosionAbility explosion = AbilityHelper.newExplosion((Entity)this.func_85052_h(), this.field_70170_p, hit.func_177958_n(), hit.func_177956_o(), hit.func_177952_p(), 14.0f);
        explosion.setStaticDamage(80.0f);
        explosion.setStaticBlockResistance(0.25f);
        explosion.setFireAfterExplosion(true);
        explosion.setSmokeParticles(new CommonExplosionParticleEffect(15));
        explosion.func_199592_a(ModDamageSource.FIRE.causeIndirectDamageFromSource(this));
        explosion.doExplosion();
    }

    private void onTickEvent() {
        if (this.func_208600_a(FluidTags.field_206959_a) && CommonConfig.INSTANCE.getDestroyWater()) {
            List<BlockPos> coords = AbilityHelper.createFilledSphere(this.func_130014_f_(), (int)this.func_226277_ct_(), (int)this.func_226278_cu_(), (int)this.func_226281_cx_(), 9, Blocks.field_150350_a, GRIEF_RULE);
            for (BlockPos blockPos : coords) {
                WyHelper.spawnParticles((IParticleData)ParticleTypes.field_197612_e, (ServerWorld)this.func_130014_f_(), (double)blockPos.func_177958_n() + WyHelper.randomDouble() / 2.0, (double)blockPos.func_177956_o() + 0.8, (double)blockPos.func_177952_p() + WyHelper.randomDouble() / 2.0);
                this.func_130014_f_().func_195594_a((IParticleData)ParticleTypes.field_197601_L, (double)blockPos.func_177958_n(), (double)blockPos.func_177956_o() + 1.1, (double)blockPos.func_177952_p(), 0.0, 0.0, 0.0);
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            GenericParticleData data;
            double offsetZ;
            double offsetY;
            int i;
            for (i = 0; i < 20; ++i) {
                double offsetX = WyHelper.randomDouble();
                offsetY = WyHelper.randomDouble();
                offsetZ = WyHelper.randomDouble();
                data = new GenericParticleData(ModParticleTypes.MERA);
                data.setLife(6);
                data.setSize(1.3f);
                WyHelper.spawnParticles(data, (ServerWorld)this.field_70170_p, this.func_226277_ct_() + offsetX, this.func_226278_cu_() + offsetY, this.func_226281_cx_() + offsetZ);
            }
            for (i = 0; i < 2; ++i) {
                double offsetX = WyHelper.randomDouble();
                offsetY = WyHelper.randomDouble();
                offsetZ = WyHelper.randomDouble();
                data = new GenericParticleData(ModParticleTypes.MOKU);
                data.setLife(4);
                data.setSize(1.2f);
                WyHelper.spawnParticles(data, (ServerWorld)this.field_70170_p, this.func_226277_ct_() + offsetX, this.func_226278_cu_() + offsetY, this.func_226281_cx_() + offsetZ);
            }
        }
    }

    @Override
    public void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SIZE, (Object)Float.valueOf(0.0f));
    }

    @Override
    public void increaseSize() {
        this.field_70180_af.func_187227_b(SIZE, (Object)Float.valueOf(Math.min(((Float)this.field_70180_af.func_187225_a(SIZE)).floatValue() + 0.1f, 17.5f)));
    }

    @Override
    public void setSize(float size) {
        this.field_70180_af.func_187227_b(SIZE, (Object)Float.valueOf(Math.min(size, 17.5f)));
    }

    @Override
    public float getSize() {
        return ((Float)this.field_70180_af.func_187225_a(SIZE)).floatValue();
    }
}

