/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.projectiles.zushi;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.FallingBlockEntity;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.IndirectEntityDamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.api.abilities.ExplosionAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.zushi.ZushiProjectiles;
import xyz.pixelatedw.mineminenomi.init.ModParticleTypes;
import xyz.pixelatedw.mineminenomi.particles.data.GenericParticleData;
import xyz.pixelatedw.mineminenomi.particles.effects.common.CommonExplosionParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.wypi.abilities.projectiles.IFlexibleSizeProjectile;

public class SagariNoRyuseiProjectile
extends AbilityProjectileEntity
implements IFlexibleSizeProjectile {
    private static final int MAX_DAMAGE = 95;

    public SagariNoRyuseiProjectile(World world) {
        super(ZushiProjectiles.SAGARI_NO_RYUSEI, world);
    }

    public SagariNoRyuseiProjectile(EntityType type, World world) {
        super(type, world);
    }

    public SagariNoRyuseiProjectile(World world, double x, double y, double z) {
        super(ZushiProjectiles.SAGARI_NO_RYUSEI, world, x, y, z);
    }

    public SagariNoRyuseiProjectile(World world, LivingEntity player) {
        super(ZushiProjectiles.SAGARI_NO_RYUSEI, world, player);
        this.setDamage(95.0f);
        this.setArmorPiercing();
        this.setMaxLife(256);
        this.setPhysical(false);
        this.setHurtThrower();
        this.setDamageSource(new IndirectEntityDamageSource("ability_projectile", (Entity)this, null).func_76349_b());
        this.onBlockImpactEvent = this::onBlockImpactEvent;
        this.onTickEvent = this::onTickEvent;
    }

    private void onBlockImpactEvent(BlockPos hit) {
        float mult = this.getSize() / 30.0f;
        ExplosionAbility explosion = AbilityHelper.newExplosion((Entity)this.func_85052_h(), this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 20.0f * mult);
        explosion.setStaticDamage(90.0f * mult);
        explosion.addRemovedBlocksToList();
        explosion.setDamageOwner(true);
        explosion.func_199592_a(new IndirectEntityDamageSource("explosion", (Entity)this, null).func_94540_d());
        explosion.setFireAfterExplosion(true);
        explosion.setSmokeParticles(new CommonExplosionParticleEffect((int)(20.0f * mult)));
        explosion.doExplosion();
        int size = 0;
        for (FallingBlockEntity entity : explosion.removedBlocks) {
            entity.func_213293_j(WyHelper.randomWithRange(-1, 1) / 2.0 * (double)mult, (0.75 + WyHelper.randomDouble()) * (double)mult, WyHelper.randomWithRange(-1, 1) / 2.0 * (double)mult);
            entity.field_70133_I = true;
            entity.field_145813_c = false;
            entity.field_145812_b = 1;
            this.field_70170_p.func_217376_c((Entity)entity);
            if (++size <= 256) continue;
            break;
        }
    }

    private void onTickEvent() {
        float mult = this.getSize() / 30.0f;
        if (1 > this.field_70173_aa) {
            this.func_174826_a(this.func_174813_aQ().func_186662_g((double)mult));
        }
        if (!this.field_70170_p.field_72995_K) {
            this.setDamage(95.0f * mult);
            for (int i = 0; i < 25; ++i) {
                ParticleType<GenericParticleData> particleToUse = this.field_70173_aa % 2 == 0 ? ModParticleTypes.MOKU : ModParticleTypes.MERA;
                double offsetX = WyHelper.randomDouble() * 5.0 * (double)mult;
                double offsetY = WyHelper.randomDouble();
                double offsetZ = WyHelper.randomDouble() * 5.0 * (double)mult;
                GenericParticleData data = new GenericParticleData(particleToUse);
                data.setLife(20);
                data.setSize(7.0f * mult);
                WyHelper.spawnParticles(data, (ServerWorld)this.field_70170_p, this.func_226277_ct_() + offsetX, this.func_226278_cu_() + offsetY, this.func_226281_cx_() + offsetZ);
            }
        }
    }

    @Override
    public void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SIZE, (Object)Float.valueOf(0.0f));
    }

    @Override
    public void increaseSize() {
        this.field_70180_af.func_187227_b(SIZE, (Object)Float.valueOf(Math.min(((Float)this.field_70180_af.func_187225_a(SIZE)).floatValue() + 0.1f, 30.0f)));
    }

    @Override
    public void setSize(float size) {
        this.field_70180_af.func_187227_b(SIZE, (Object)Float.valueOf(Math.min(size, 30.0f)));
    }

    @Override
    public float getSize() {
        return ((Float)this.field_70180_af.func_187225_a(SIZE)).floatValue();
    }
}

