/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.events;

import java.util.Random;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SwordItem;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import xyz.pixelatedw.mineminenomi.abilities.haki.BusoshokuHakiHardeningAbility;
import xyz.pixelatedw.mineminenomi.abilities.haki.BusoshokuHakiImbuingAbility;
import xyz.pixelatedw.mineminenomi.abilities.haki.HaoshokuHakiAbility;
import xyz.pixelatedw.mineminenomi.abilities.haki.KenbunshokuHakiAuraAbility;
import xyz.pixelatedw.mineminenomi.api.events.HakiExpEvent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.HakiHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.ItemsHelper;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.data.entity.haki.HakiDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.haki.IHakiData;
import xyz.pixelatedw.mineminenomi.entities.mobs.OPEntity;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.Ability;
import xyz.pixelatedw.mineminenomi.wypi.abilities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.wypi.network.WyNetwork;
import xyz.pixelatedw.mineminenomi.wypi.network.packets.server.SSyncAbilityDataPacket;

@Mod.EventBusSubscriber(modid="mineminenomi")
public class HakiGainEvents {
    @SubscribeEvent
    public static void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving() instanceof PlayerEntity && !event.getEntityLiving().field_70170_p.field_72995_K) {
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            IAbilityData props = AbilityDataCapability.get((LivingEntity)player);
            IHakiData hakiProps = HakiDataCapability.get((LivingEntity)player);
            float hakiMultiplier = (float)CommonConfig.INSTANCE.getHakiExpMultiplier();
            player.field_70170_p.func_217381_Z().func_76320_a("hakiExpGain");
            KenbunshokuHakiAuraAbility ability = props.getEquippedAbility(KenbunshokuHakiAuraAbility.INSTANCE);
            if (ability != null && ability.isContinuous() && hakiProps.getKenbunshokuHakiExp() >= 60.0f && player.field_70173_aa % 600 == 0 && (double)player.func_110143_aJ() < WyHelper.percentage(20.0, player.func_110138_aP())) {
                float finalHakiExp = 0.025f * hakiMultiplier;
                hakiProps.alterKenbunshokuHakiExp(finalHakiExp);
                HakiExpEvent e = new HakiExpEvent(player, finalHakiExp);
                MinecraftForge.EVENT_BUS.post((Event)e);
            }
            if (CommonConfig.INSTANCE.isHaoshokuUnlockLogicExpBased() && player.field_70173_aa % 1200 == 0 && !props.hasUnlockedAbility(HaoshokuHakiAbility.INSTANCE)) {
                float totalPossible = CommonConfig.INSTANCE.getHakiExpLimit() * 3;
                float totalExp = HakiHelper.getTotalHakiExp((LivingEntity)player);
                float totalCheck = (float)(150.0 + WyHelper.randomWithRange(-50, 120));
                if (totalExp >= (totalCheck = MathHelper.func_76131_a((float)totalCheck, (float)0.0f, (float)totalPossible))) {
                    HakiGainEvents.giveHakiAbility(player, HaoshokuHakiAbility.INSTANCE);
                }
            }
            player.field_70170_p.func_217381_Z().func_76319_b();
        }
    }

    @SubscribeEvent
    public static void onEntityAttack(LivingHurtEvent event) {
        AbilityProjectileEntity entity;
        if (event.getAmount() < 1.0f || !(event.getEntityLiving() instanceof PlayerEntity) || !(event.getSource().func_76346_g() instanceof LivingEntity) || event.getEntityLiving().field_70170_p.field_72995_K || event.getSource().func_94541_c()) {
            return;
        }
        if (event.getSource().func_76364_f() instanceof AbilityProjectileEntity && !(entity = (AbilityProjectileEntity)event.getSource().func_76364_f()).isPhysical()) {
            return;
        }
        PlayerEntity player = (PlayerEntity)event.getEntityLiving();
        IHakiData hakiProps = HakiDataCapability.get((LivingEntity)player);
        IAbilityData abilityProps = AbilityDataCapability.get((LivingEntity)player);
        Random rand = player.func_70681_au();
        rand.setSeed(player.func_110124_au().getMostSignificantBits());
        player.field_70170_p.func_217381_Z().func_76320_a("hakiExpGain");
        float hakiMultiplier = (float)CommonConfig.INSTANCE.getHakiExpMultiplier();
        KenbunshokuHakiAuraAbility ability = abilityProps.getEquippedAbility(KenbunshokuHakiAuraAbility.INSTANCE);
        if (ability != null && ability.isContinuous() || (double)hakiProps.getKenbunshokuHakiExp() <= 10.0 + HakiHelper.getKenbunshokuAuraExpNeeded(rand)) {
            float exp = event.getAmount() / (20.0f + 100.0f * (hakiProps.getKenbunshokuHakiExp() / 100.0f));
            if (exp <= 0.0f) {
                exp = 1.0E-5f;
            }
            float finalHakiExp = exp * hakiMultiplier;
            hakiProps.alterKenbunshokuHakiExp(finalHakiExp);
            HakiExpEvent e = new HakiExpEvent(player, finalHakiExp);
            MinecraftForge.EVENT_BUS.post((Event)e);
        }
        player.field_70170_p.func_217381_Z().func_76319_b();
    }

    @SubscribeEvent
    public static void onEntityDeath(LivingDeathEvent event) {
        float expValue;
        AbilityProjectileEntity entity;
        if (!(event.getSource().func_76346_g() instanceof PlayerEntity) || event.getSource().func_76346_g().field_70170_p.field_72995_K) {
            return;
        }
        if (event.getSource().func_76364_f() instanceof AbilityProjectileEntity && !(entity = (AbilityProjectileEntity)event.getSource().func_76364_f()).isPhysical()) {
            return;
        }
        PlayerEntity player = (PlayerEntity)event.getSource().func_76346_g();
        IHakiData hakiProps = HakiDataCapability.get((LivingEntity)player);
        IAbilityData abilityProps = AbilityDataCapability.get((LivingEntity)player);
        ItemStack heldStack = player.func_184586_b(player.func_184600_cs());
        Random rand = player.func_70681_au();
        rand.setSeed(player.func_110124_au().getMostSignificantBits());
        player.field_70170_p.func_217381_Z().func_76320_a("hakiExpGain");
        float hakiMultiplier = (float)CommonConfig.INSTANCE.getHakiExpMultiplier();
        IAttributeInstance attrAtk = event.getEntityLiving().func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111264_e);
        IAttributeInstance attrHP = event.getEntityLiving().func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111267_a);
        double atk = attrAtk != null ? attrAtk.func_111125_b() : 0.0;
        double hp = attrHP != null ? attrHP.func_111125_b() : 0.0;
        float f = expValue = event.getEntityLiving() instanceof OPEntity ? (float)(atk + hp) * 1.5f : Math.min((float)(atk + hp), 50.0f);
        if (!heldStack.func_190926_b() && heldStack.func_77973_b() instanceof SwordItem) {
            if (expValue < hakiProps.getBusoshokuImbuingHakiExp()) {
                return;
            }
            BusoshokuHakiImbuingAbility ability = abilityProps.getEquippedAbility(BusoshokuHakiImbuingAbility.INSTANCE);
            if (ability != null && ability.isContinuous() || (double)hakiProps.getBusoshokuImbuingHakiExp() <= 10.0 + HakiHelper.getBusoshokuImbuingExpNeeded(rand)) {
                float exp = expValue / (1200.0f + 3600.0f * (hakiProps.getBusoshokuImbuingHakiExp() / 100.0f));
                if (exp <= 0.0f) {
                    exp = 1.0E-4f;
                }
                float finalHakiExp = exp * hakiMultiplier;
                if (!ItemsHelper.isSword(heldStack)) {
                    finalHakiExp = exp * hakiMultiplier / 4.0f;
                }
                hakiProps.alterBusoshokuImbuingHakiExp(exp * hakiMultiplier);
                HakiExpEvent e = new HakiExpEvent(player, finalHakiExp);
                MinecraftForge.EVENT_BUS.post((Event)e);
            }
        } else if (heldStack.func_190926_b()) {
            if (expValue < hakiProps.getBusoshokuHardeningHakiExp()) {
                return;
            }
            BusoshokuHakiHardeningAbility ability = abilityProps.getEquippedAbility(BusoshokuHakiHardeningAbility.INSTANCE);
            if (ability != null && ability.isContinuous() || (double)hakiProps.getBusoshokuHardeningHakiExp() <= 10.0 + HakiHelper.getBusoshokuHardeningExpNeeded(rand)) {
                float exp = expValue / (900.0f + 2700.0f * (hakiProps.getBusoshokuHardeningHakiExp() / 100.0f));
                if (exp <= 0.0f) {
                    exp = 1.0E-4f;
                }
                float finalHakiExp = exp * hakiMultiplier;
                hakiProps.alterBusoshokuHardeningHakiExp(finalHakiExp);
                HakiExpEvent e = new HakiExpEvent(player, finalHakiExp);
                MinecraftForge.EVENT_BUS.post((Event)e);
            }
        }
        player.field_70170_p.func_217381_Z().func_76319_b();
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof PlayerEntity && !event.getWorld().field_72995_K && CommonConfig.INSTANCE.isHaoshokuUnlockLogicChanceBased()) {
            PlayerEntity player = (PlayerEntity)event.getEntity();
            boolean isKing = false;
            String[] bits = ("" + player.func_110124_au().getMostSignificantBits()).split("");
            int playerBitsSum = 0;
            for (String bit : bits) {
                if (bit.equalsIgnoreCase("-")) continue;
                playerBitsSum += Integer.parseInt(bit);
            }
            playerBitsSum = MathHelper.func_76125_a((int)(playerBitsSum & 0xA), (int)0, (int)10);
            if (CommonConfig.INSTANCE.getHaoshokuUnlockLogic() == CommonConfig.HaoshokuUnlockLogic.TRUE_RANDOM) {
                String[] seedBits = String.valueOf(player.field_70170_p.func_72905_C()).split("");
                int worldBitsSum = 0;
                for (String bit : seedBits) {
                    if (bit.equalsIgnoreCase("-")) continue;
                    worldBitsSum += Integer.parseInt(bit);
                }
                isKing = playerBitsSum == (worldBitsSum = MathHelper.func_76125_a((int)(worldBitsSum & 0xA), (int)0, (int)10));
            } else {
                boolean bl = isKing = playerBitsSum <= 1;
            }
            if (isKing) {
                HakiGainEvents.giveHakiAbility(player, HaoshokuHakiAbility.INSTANCE);
            }
        }
    }

    public static void giveHakiAbility(PlayerEntity player, Ability ability) {
        IAbilityData props = AbilityDataCapability.get((LivingEntity)player);
        if (!props.hasUnlockedAbility(ability) && !AbilityHelper.verifyIfAbilityIsBanned(ability)) {
            props.addUnlockedAbility(ability);
            if (!player.field_70170_p.field_72995_K) {
                WyNetwork.sendTo(new SSyncAbilityDataPacket(player.func_145782_y(), props), player);
            }
        }
    }
}

