/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.events.abilities;

import java.util.Arrays;
import java.util.Objects;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import xyz.pixelatedw.mineminenomi.api.abilities.DamagedContinuousAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.DamagedPassiveAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.HurtPassiveAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.IFallDamageBlockingAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.ISniperAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.PotionPassiveAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.TempoAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.FactionHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.HakiHelper;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.DevilFruitCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.wypi.APIConfig;
import xyz.pixelatedw.mineminenomi.wypi.abilities.Ability;
import xyz.pixelatedw.mineminenomi.wypi.abilities.ChargeableAbility;
import xyz.pixelatedw.mineminenomi.wypi.abilities.ContinuousAbility;
import xyz.pixelatedw.mineminenomi.wypi.abilities.IChangeDamageSourceAbility;
import xyz.pixelatedw.mineminenomi.wypi.abilities.PassiveAbility;
import xyz.pixelatedw.mineminenomi.wypi.abilities.PunchAbility;
import xyz.pixelatedw.mineminenomi.wypi.abilities.RepeaterAbility;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.wypi.debug.WyDebug;

@Mod.EventBusSubscriber(modid="mineminenomi")
public class AbilitiesEvents {
    @SubscribeEvent
    public static void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            IAbilityData ablProps = AbilityDataCapability.get((LivingEntity)player);
            player.field_70170_p.func_217381_Z().func_76320_a("abilityCooldown");
            for (Ability ability : ablProps.getUnlockedAbilities(APIConfig.AbilityCategory.ALL)) {
                if (ability == null) continue;
                try {
                    if (ability instanceof PassiveAbility) {
                        ((PassiveAbility)ablProps.getUnlockedAbility(ability)).tick(player);
                    }
                    if (!(ability instanceof TempoAbility)) continue;
                    ablProps.getUnlockedAbility(ability).cooldown(player);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    ability.startCooldown(player);
                }
            }
            player.field_70170_p.func_217381_Z().func_76319_b();
            player.field_70170_p.func_217381_Z().func_76320_a("abilityTick");
            for (Ability ability : ablProps.getEquippedAbilities(APIConfig.AbilityCategory.ALL)) {
                if (ability == null) continue;
                try {
                    if (ability instanceof ChargeableAbility && ability.isCharging()) {
                        ((ChargeableAbility)ablProps.getEquippedAbility(ability)).charging(player);
                    }
                    if (ability instanceof ContinuousAbility && ability.isContinuous()) {
                        ((ContinuousAbility)ablProps.getEquippedAbility(ability)).tick(player);
                    }
                    if (ability.isDisabled()) {
                        ablProps.getEquippedAbility(ability).disableTick(player);
                    }
                    if (!ability.isOnCooldown()) continue;
                    ablProps.getEquippedAbility(ability).cooldown(player);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    ability.startCooldown(player);
                }
            }
            player.field_70170_p.func_217381_Z().func_76319_b();
        }
    }

    @SubscribeEvent
    public static void onPlayerDies(LivingDeathEvent event) {
        if (event.getEntityLiving() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            IAbilityData ablProps = AbilityDataCapability.get((LivingEntity)player);
            for (Ability ability : ablProps.getEquippedAbilities(APIConfig.AbilityCategory.ALL)) {
                if (ability == null) continue;
                try {
                    if (ability.getState() == Ability.State.CONTINUOUS) {
                        if (ability instanceof ContinuousAbility) {
                            ((ContinuousAbility)ability).stopContinuity(player);
                        }
                        if (!(ability instanceof RepeaterAbility)) continue;
                        ((RepeaterAbility)ability).setRepeaterCount(((RepeaterAbility)ability).getMaxRepeaterCount());
                        continue;
                    }
                    if (ability instanceof ChargeableAbility && ability.getState() == Ability.State.CHARGING) {
                        ((ChargeableAbility)ability).setChargeTime(((ChargeableAbility)ability).getMaxChargeTime() / 20);
                        ability.startCooldown(player);
                        continue;
                    }
                    ability.startCooldown(player);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    ability.startCooldown(player);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onEntityAttackEvent(LivingHurtEvent event) {
        if (event.getEntityLiving() != null && !event.getEntityLiving().field_70170_p.field_72995_K) {
            LivingEntity entity = event.getEntityLiving();
            IAbilityData ablProps = AbilityDataCapability.get(entity);
            for (Ability ability : ablProps.getUnlockedAbilities(APIConfig.AbilityCategory.ALL)) {
                if (ability == null) continue;
                try {
                    if (!(ability instanceof HurtPassiveAbility)) continue;
                    HurtPassiveAbility hurtAbility = (HurtPassiveAbility)ablProps.getUnlockedAbility(ability);
                    boolean result = hurtAbility.hurt(entity, event.getSource().func_76346_g(), event.getAmount());
                    event.setAmount(hurtAbility.getAmount());
                    event.setCanceled(!result);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @SubscribeEvent
    public static void onEntityAttackEvent(LivingAttackEvent event) {
        if (event.getEntityLiving() != null && !event.getEntityLiving().field_70170_p.field_72995_K) {
            LivingEntity entity = event.getEntityLiving();
            IAbilityData ablProps = AbilityDataCapability.get(entity);
            if (!CommonConfig.INSTANCE.isAbilityInvulnerabilityEnabled()) {
                return;
            }
            for (Ability ability2 : ablProps.getUnlockedAbilities(APIConfig.AbilityCategory.ALL)) {
                if (ability2 == null) continue;
                try {
                    if (!(ability2 instanceof DamagedPassiveAbility)) continue;
                    boolean result = ((DamagedPassiveAbility)ablProps.getUnlockedAbility(ability2)).damage(entity, event.getSource());
                    event.setCanceled(!result);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            for (Ability ability3 : ablProps.getEquippedAbilities()) {
                if (ability3 == null) continue;
                try {
                    boolean blockFallDamage;
                    if (ability3 instanceof DamagedContinuousAbility && ability3.isContinuous()) {
                        boolean result = ((DamagedContinuousAbility)ablProps.getUnlockedAbility(ability3)).damage(entity, event.getSource(), event.getAmount());
                        event.setCanceled(!result);
                    }
                    if (!(ability3 instanceof IFallDamageBlockingAbility) || event.getSource() != DamageSource.field_76379_h) continue;
                    boolean bl = blockFallDamage = !((IFallDamageBlockingAbility)((Object)ability3)).hasFallDamage();
                    if (!blockFallDamage) continue;
                    entity.field_70143_R = 0.0f;
                    ((IFallDamageBlockingAbility)((Object)ability3)).resetFallDamage(entity);
                    event.setCanceled(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (event.getSource().func_76364_f() instanceof PlayerEntity && (event.getSource().func_76355_l().equals("player") || event.getSource().func_76355_l().equals("mob")) && event.getAmount() > 0.0f) {
                PlayerEntity attacker = (PlayerEntity)event.getSource().func_76364_f();
                ablProps = AbilityDataCapability.get((LivingEntity)attacker);
                Arrays.stream(ablProps.getEquippedAbilities(APIConfig.AbilityCategory.ALL)).filter(Objects::nonNull).forEach(ability -> {
                    try {
                        IChangeDamageSourceAbility abl;
                        if (ability instanceof IChangeDamageSourceAbility && (abl = (IChangeDamageSourceAbility)ability).isSourceChangeEnabled()) {
                            boolean sameGroup = FactionHelper.getSameGroupPredicate((LivingEntity)attacker).test((Entity)entity);
                            if (sameGroup) {
                                return;
                            }
                            double strength = attacker.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
                            if (strength == 0.0) {
                                return;
                            }
                            float damage = (float)((double)abl.damageToEntityWithSource(attacker, entity) * ((double)event.getAmount() / strength));
                            DamageSource source = abl.getSourceToUse(attacker);
                            boolean damaged = true;
                            if (entity.field_70172_ad == 0 || abl.cancelsOriginalDamage()) {
                                damaged = entity.func_70097_a(source, damage);
                                entity.field_70172_ad = 0;
                                entity.field_70737_aN = 0;
                            }
                            if (!damaged || abl.cancelsOriginalDamage()) {
                                event.setCanceled(true);
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                });
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onAttackedByPlayer(AttackEntityEvent event) {
        if (!event.getPlayer().field_70170_p.field_72995_K && event.getTarget() instanceof LivingEntity) {
            PlayerEntity player = event.getPlayer();
            ItemStack heldItem = player.func_184614_ca();
            if (!heldItem.func_190926_b()) {
                return;
            }
            IEntityStats statProps = EntityStatsCapability.get((LivingEntity)player);
            IAbilityData props = AbilityDataCapability.get((LivingEntity)player);
            LivingEntity target = (LivingEntity)event.getTarget();
            boolean isTargetLogia = DevilFruitCapability.get(target).isLogia();
            boolean isHardeningActive = HakiHelper.hasHardeningActive((LivingEntity)player);
            if (isTargetLogia && !isHardeningActive) {
                return;
            }
            for (Ability ability : props.getEquippedAbilities(APIConfig.AbilityCategory.ALL)) {
                if (ability == null) continue;
                try {
                    if (!(ability instanceof PunchAbility) || !ability.isContinuous()) continue;
                    float damage = ((PunchAbility)props.getEquippedAbility(ability)).hitEntity(player, target);
                    if (damage <= 0.0f) {
                        event.setCanceled(true);
                        return;
                    }
                    float strength = (float)player.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
                    float finalDamage = (damage + strength) * (float)statProps.getDamageMultiplier();
                    WyDebug.debug("Hardening Haki Punch Damage: " + finalDamage);
                    target.func_70097_a((DamageSource)ModDamageSource.causeAbilityDamage(player, ability), finalDamage);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    ability.startCooldown(player);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onPlayarLogsOut(PlayerEvent.PlayerLoggedOutEvent event) {
        if (event.getPlayer().field_70170_p.field_72995_K) {
            return;
        }
        PlayerEntity player = event.getPlayer();
        IAbilityData props = AbilityDataCapability.get((LivingEntity)player);
        for (Ability ability : props.getEquippedAbilities(APIConfig.AbilityCategory.ALL)) {
            if (ability == null) continue;
            try {
                if (ability instanceof ChargeableAbility && ability.isCharging()) {
                    ((ChargeableAbility)props.getEquippedAbility(ability)).stopCharging(player);
                }
                if (!(ability instanceof ContinuousAbility) || !ability.isContinuous()) continue;
                ((ContinuousAbility)props.getEquippedAbility(ability)).stopContinuity(player);
            }
            catch (Exception e) {
                e.printStackTrace();
                ability.startCooldown(player);
            }
        }
    }

    @SubscribeEvent
    public static void onPotionEvent(PotionEvent.PotionApplicableEvent event) {
        if (!(event.getEntityLiving() instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)event.getEntityLiving();
        IAbilityData props = AbilityDataCapability.get((LivingEntity)player);
        for (Ability ability : props.getUnlockedAbilities(APIConfig.AbilityCategory.ALL)) {
            if (ability == null) continue;
            try {
                if (!(ability instanceof PotionPassiveAbility)) continue;
                boolean applied = ((PotionPassiveAbility)props.getUnlockedAbility(ability)).check(player, event.getPotionEffect());
                if (applied) {
                    event.setResult(Event.Result.ALLOW);
                    continue;
                }
                event.setResult(Event.Result.DENY);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @SubscribeEvent
    public static void onEntityShootProjectile(ArrowLooseEvent event) {
        if (event.getPlayer() != null) {
            IAbilityData props = AbilityDataCapability.get((LivingEntity)event.getPlayer());
            for (Ability abl : props.getEquippedAbilities()) {
                if (!(abl instanceof ISniperAbility) || !props.hasEquippedAbility(abl) || !props.getEquippedAbility(abl).isContinuous()) continue;
                ((ISniperAbility)((Object)props.getEquippedAbility(abl))).shoot(event.getPlayer());
                props.getEquippedAbility(abl).use(event.getPlayer());
                event.setCanceled(true);
            }
        }
    }
}

