/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.events.passives;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.Quaternion;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.CombatRules;
import net.minecraft.util.DamageSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import xyz.pixelatedw.mineminenomi.abilities.LogiaInvulnerabilityAbility;
import xyz.pixelatedw.mineminenomi.abilities.haki.KenbunshokuHakiAuraAbility;
import xyz.pixelatedw.mineminenomi.abilities.haki.KenbunshokuHakiFutureSightAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.HakiHelper;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.DevilFruitCapability;
import xyz.pixelatedw.mineminenomi.data.entity.haki.HakiDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.haki.IHakiData;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.wypi.abilities.Ability;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.IAbilityData;

@Mod.EventBusSubscriber(modid="mineminenomi")
public class HakiPassiveEvents {
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onEntityAttackEvent(LivingAttackEvent event) {
        int absorbed;
        boolean isActive;
        if (!(event.getEntityLiving() instanceof PlayerEntity) || event.getEntity().field_70170_p.field_72995_K) {
            return;
        }
        PlayerEntity player = (PlayerEntity)event.getEntityLiving();
        IAbilityData abilityProps = AbilityDataCapability.get((LivingEntity)player);
        IHakiData hakiProps = HakiDataCapability.get((LivingEntity)player);
        int hakiOveruse = 10 + (int)(HakiHelper.getMaxOveruse(player) / 1180.0f);
        KenbunshokuHakiFutureSightAbility futureSight = abilityProps.getEquippedAbility(KenbunshokuHakiFutureSightAbility.INSTANCE);
        boolean bl = isActive = futureSight != null && futureSight.isContinuous();
        if (!isActive) {
            return;
        }
        float amount = event.getAmount();
        DamageSource damageSource = event.getSource();
        ArrayList<DamageSource> damageableSources = new ArrayList<DamageSource>(Arrays.asList(DamageSource.field_76371_c, DamageSource.field_76368_d, DamageSource.field_76367_g, DamageSource.field_220302_v, DamageSource.field_76366_f, DamageSource.field_82728_o, DamageSource.field_188406_j, DamageSource.field_76379_h, DamageSource.field_82729_p, DamageSource.field_76380_i, DamageSource.field_82727_n, DamageSource.field_76376_m, DamageSource.field_76372_a, DamageSource.field_76370_b, DamageSource.field_180137_b));
        boolean isLogia = DevilFruitCapability.get((LivingEntity)player).isLogia();
        LogiaInvulnerabilityAbility invulnerabilityInstance = null;
        if (isLogia) {
            List unlockedAbilities = abilityProps.getUnlockedAbilities(AbilityHelper.getDevilFruitCategory());
            for (Ability ability : unlockedAbilities) {
                if (!(ability instanceof LogiaInvulnerabilityAbility)) continue;
                invulnerabilityInstance = (LogiaInvulnerabilityAbility)ability;
                if (!invulnerabilityInstance.onDamagedEvent((LivingEntity)player, damageSource)) {
                    event.setCanceled(true);
                    return;
                }
                damageableSources.removeAll(invulnerabilityInstance.immunitySources);
            }
            hakiOveruse /= 3;
        } else if (damageSource.func_94541_c()) {
            return;
        }
        if (!(player.field_70172_ad <= 0 || damageableSources.contains(damageSource) || damageSource.func_76355_l().equals("special") || isLogia)) {
            hakiProps.alterHakiOveruse(hakiOveruse * 4);
            event.setCanceled(true);
            return;
        }
        if (!damageSource.func_76363_c()) {
            amount = CombatRules.func_189427_a((float)amount, (float)player.func_70658_aO(), (float)((float)player.func_110148_a(SharedMonsterAttributes.field_189429_h).func_111126_e()));
        }
        if ((absorbed = EnchantmentHelper.func_77508_a((Iterable)player.func_184193_aE(), (DamageSource)damageSource)) > 0) {
            amount = CombatRules.func_188401_b((float)amount, (float)absorbed);
        }
        if (0.0f > amount) {
            event.setCanceled(true);
            return;
        }
        boolean baseCondition = damageableSources.stream().noneMatch(s -> damageSource.func_76355_l().equals(s.func_76355_l()));
        if (baseCondition) {
            futureSight.reduceProtection(amount);
            hakiProps.alterHakiOveruse(hakiOveruse * 4 + (int)(amount * (float)hakiOveruse));
            Objects.requireNonNull(player);
            player.field_70737_aN = 20;
            player.field_70172_ad = 20;
            if (invulnerabilityInstance != null) {
                invulnerabilityInstance.particleEffect.spawn(player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), 0.0, 0.0, 0.0);
            }
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onPlayerUpdate(TickEvent.PlayerTickEvent event) {
        int ticksToHeal;
        PlayerEntity player = event.player;
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        IHakiData hakiProps = HakiDataCapability.get((LivingEntity)player);
        float maxOveruse = HakiHelper.getMaxOveruse(player);
        float haikuOveruse = hakiProps.getHakiOveruse();
        if ((double)haikuOveruse >= (double)maxOveruse * 0.75) {
            player.func_195064_c(new EffectInstance(ModEffects.HAKI_OVERUSE, 40, 0));
            player.func_195064_c(new EffectInstance(Effects.field_76437_t, 40, 0, true, false));
            player.func_195064_c(new EffectInstance(Effects.field_76438_s, 40, 1, true, false));
            if ((double)haikuOveruse >= (double)maxOveruse * 0.8) {
                player.func_195064_c(new EffectInstance(ModEffects.HAKI_OVERUSE, 80, 1));
                player.func_195064_c(new EffectInstance(Effects.field_76421_d, 80, 1, true, false));
                if ((double)haikuOveruse >= (double)maxOveruse * 0.95) {
                    player.func_195064_c(new EffectInstance(ModEffects.HAKI_OVERUSE, 100, 2));
                    player.func_195064_c(new EffectInstance(Effects.field_76438_s, 100, 2, true, false));
                    player.func_195064_c(new EffectInstance(Effects.field_76437_t, 100, 2, true, false));
                    player.func_195064_c(new EffectInstance(Effects.field_76421_d, 100, 2, true, false));
                    player.func_195064_c(new EffectInstance(Effects.field_76440_q, 100, 0, true, false));
                }
            }
        }
        int n = ticksToHeal = HakiHelper.hasAnyHakiEnabled((LivingEntity)player) ? 300 : 60;
        if (player.field_70173_aa % ticksToHeal != 0) {
            return;
        }
        int overuseHeal = -Math.max(6, Math.min(1, (int)(HakiHelper.getTotalHakiExp((LivingEntity)player) / 50.0f)));
        if (haikuOveruse - (float)overuseHeal > 0.0f) {
            hakiProps.alterHakiOveruse(overuseHeal);
        } else {
            hakiProps.setHakiOveruse(0);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onEntityRendered(RenderLivingEvent.Pre event) {
        if (event.getEntity() == null) {
            return;
        }
        LivingEntity entity = event.getEntity();
        if (entity.func_70644_a(ModEffects.UNCONSCIOUS)) {
            float angle;
            if (entity.func_70660_b(ModEffects.UNCONSCIOUS).func_76459_b() <= 0) {
                entity.func_195063_d(ModEffects.UNCONSCIOUS);
            }
            if ((angle = (float)(entity.func_145782_y() % 8)) == 0.0f) {
                event.getMatrixStack().func_227863_a_(new Quaternion(Vector3f.field_229179_b_, 90.0f, true));
                entity.field_70759_as = 0.0f;
                entity.field_70758_at = 0.0f;
            } else if (angle == 1.0f) {
                event.getMatrixStack().func_227863_a_(new Quaternion(Vector3f.field_229181_d_, 45.0f, true));
                event.getMatrixStack().func_227863_a_(new Quaternion(Vector3f.field_229183_f_, 90.0f, true));
                entity.field_70759_as = 45.0f;
                entity.field_70758_at = 45.0f;
            } else if (angle == 2.0f) {
                event.getMatrixStack().func_227863_a_(new Quaternion(Vector3f.field_229183_f_, 90.0f, true));
                event.getMatrixStack().func_227863_a_(new Quaternion(Vector3f.field_229180_c_, 90.0f, true));
                entity.field_70759_as = 90.0f;
                entity.field_70758_at = 90.0f;
            } else if (angle == 3.0f) {
                event.getMatrixStack().func_227863_a_(new Quaternion(Vector3f.field_229181_d_, 45.0f, true));
                event.getMatrixStack().func_227863_a_(new Quaternion(Vector3f.field_229178_a_, 90.0f, true));
                entity.field_70759_as = 90.0f;
                entity.field_70758_at = 90.0f;
            } else if (angle == 4.0f) {
                event.getMatrixStack().func_227863_a_(new Quaternion(Vector3f.field_229178_a_, 90.0f, true));
                event.getMatrixStack().func_227863_a_(new Quaternion(Vector3f.field_229181_d_, 180.0f, true));
                entity.field_70759_as = 90.0f;
                entity.field_70758_at = 90.0f;
            } else if (angle == 5.0f) {
                event.getMatrixStack().func_227863_a_(new Quaternion(Vector3f.field_229181_d_, 45.0f, true));
                event.getMatrixStack().func_227863_a_(new Quaternion(Vector3f.field_229182_e_, 90.0f, true));
                entity.field_70759_as = 90.0f;
                entity.field_70758_at = 90.0f;
            } else if (angle == 6.0f) {
                event.getMatrixStack().func_227863_a_(new Quaternion(Vector3f.field_229182_e_, 90.0f, true));
                event.getMatrixStack().func_227863_a_(new Quaternion(Vector3f.field_229181_d_, 90.0f, true));
                entity.field_70759_as = 360.0f;
                entity.field_70758_at = 360.0f;
            } else if (angle == 7.0f) {
                event.getMatrixStack().func_227863_a_(new Quaternion(Vector3f.field_229180_c_, 45.0f, true));
                event.getMatrixStack().func_227863_a_(new Quaternion(Vector3f.field_229182_e_, 90.0f, true));
                entity.field_70759_as = 360.0f;
                entity.field_70758_at = 360.0f;
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onFogRendered(EntityViewRenderEvent.FogDensity event) {
        boolean isActive;
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        IAbilityData props = AbilityDataCapability.get((LivingEntity)player);
        KenbunshokuHakiAuraAbility ability = props.getEquippedAbility(KenbunshokuHakiAuraAbility.INSTANCE);
        boolean bl = isActive = ability != null && ability.isContinuous();
        if (isActive && player.func_70644_a(Effects.field_76440_q)) {
            event.setCanceled(true);
            event.setDensity(1.0E-4f);
        }
    }
}

