/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.items;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.packets.server.SSyncEntityStatsPacket;
import xyz.pixelatedw.mineminenomi.wypi.network.WyNetwork;

public class HeartItem
extends Item {
    private static final DamageSource DAMAGE_SOURCE = new DamageSource("magic").func_76348_h().func_82726_p().func_76359_i().func_151518_m();

    public HeartItem() {
        super(new Item.Properties().func_200917_a(1));
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        if (world.field_72995_K) {
            return new ActionResult(ActionResultType.SUCCESS, (Object)player.func_184586_b(hand));
        }
        ItemStack itemStack = player.func_184586_b(hand);
        LivingEntity owner = this.getOwner(world, player.func_180425_c(), itemStack);
        if (owner == null) {
            player.field_71071_by.func_184437_d(itemStack);
            return ActionResult.func_226248_a_((Object)itemStack);
        }
        IEntityStats props = EntityStatsCapability.get(owner);
        if (props.hasHeart()) {
            player.field_71071_by.func_184437_d(itemStack);
            return ActionResult.func_226248_a_((Object)itemStack);
        }
        if (itemStack.func_196082_o() != null) {
            if (owner == player) {
                props.setHeart(true);
                WyNetwork.sendToServer(new SSyncEntityStatsPacket(player.func_145782_y(), props));
                player.field_71071_by.func_184437_d(itemStack);
            } else {
                owner.func_70097_a(DAMAGE_SOURCE, 5.0f);
                owner.func_195064_c(new EffectInstance(Effects.field_76421_d, 250, 1));
                owner.func_195064_c(new EffectInstance(Effects.field_76431_k, 250, 1));
                if (owner.func_110143_aJ() <= 0.0f) {
                    player.field_71071_by.func_184437_d(itemStack);
                }
            }
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)player.func_184586_b(hand));
    }

    @Nullable
    public LivingEntity getOwner(World world, BlockPos pos, ItemStack itemStack) {
        UUID uuid = itemStack.func_196082_o().func_186857_a("ownerUUID");
        return (LivingEntity)((ServerWorld)world).func_217461_a(uuid);
    }

    public boolean onEntityItemUpdate(ItemStack itemStack, ItemEntity entityItem) {
        LivingEntity target;
        if (entityItem.field_70170_p.field_72995_K) {
            return false;
        }
        if (itemStack.func_77978_p() != null && (target = this.getOwner(entityItem.field_70170_p, entityItem.func_180425_c(), itemStack)) != null) {
            boolean isInVoid;
            boolean isBurning = entityItem.func_70027_ad();
            boolean bl = isInVoid = entityItem.func_180425_c().func_177956_o() < -1;
            if (isBurning || isInVoid) {
                for (ItemStack stack : target.func_184214_aD()) {
                    if (stack.func_77973_b() != Items.field_190929_cY) continue;
                    stack.func_190918_g(stack.func_190916_E());
                }
                target.func_70097_a(DAMAGE_SOURCE, target.func_110138_aP() + target.func_110139_bj() + 1.0f);
            }
        }
        return false;
    }

    public void setHeartOwner(ItemStack itemStack, LivingEntity owner) {
        itemStack.func_77982_d(new CompoundNBT());
        itemStack.func_77978_p().func_186854_a("ownerUUID", owner.func_110124_au());
    }
}

