/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.models.entities.mobs.humanoids;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Quaternion;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.util.HandSide;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import xyz.pixelatedw.mineminenomi.entities.mobs.OPEntity;
import xyz.pixelatedw.mineminenomi.init.ModWeapons;

@OnlyIn(value=Dist.CLIENT)
public class HumanoidModel<T extends OPEntity>
extends BipedModel<T> {
    protected float animationTimer = 0.0f;
    public HumanoidArmPose armsPose = HumanoidArmPose.EMPTY;

    public HumanoidModel() {
        super(0.0f, 0.0f, 64, 64);
        this.field_178720_f.field_78806_j = false;
    }

    public void func_225598_a_(MatrixStack matrixStack, IVertexBuilder buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        super.func_225598_a_(matrixStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void setRotationAngles(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.func_225597_a_(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        if (this.armsPose == HumanoidArmPose.SENRIKU_HOLDING) {
            this.func_187074_a((HandSide)HandSide.LEFT).field_78795_f = this.func_187074_a((HandSide)HandSide.LEFT).field_78795_f * 0.5f - 0.31415927f;
            this.func_187074_a((HandSide)HandSide.LEFT).field_78796_g = 0.0f;
        } else if (this.armsPose == HumanoidArmPose.SENRIKU_POINTING) {
            this.field_178723_h.field_78796_g = 0.3f + this.field_78116_c.field_78796_g - 0.4f;
            this.field_178724_i.field_78796_g = 0.8f + this.field_78116_c.field_78796_g;
            this.field_178723_h.field_78795_f = -1.5707964f + this.field_78116_c.field_78795_f;
            this.field_178724_i.field_78795_f = -1.5707964f + this.field_78116_c.field_78795_f;
        } else if (this.armsPose == HumanoidArmPose.FLINTLOCK_POINTING) {
            HandSide side = entity.func_184582_a(EquipmentSlotType.MAINHAND).func_77973_b() == ModWeapons.FLINTLOCK ? HandSide.RIGHT : HandSide.LEFT;
            HandSide opposide = entity.func_184582_a(EquipmentSlotType.MAINHAND).func_77973_b() == ModWeapons.FLINTLOCK ? HandSide.LEFT : HandSide.RIGHT;
            this.func_187074_a((HandSide)side).field_78796_g = -0.1f + this.field_78116_c.field_78796_g - 0.4f;
            this.func_187074_a((HandSide)opposide).field_78796_g = 0.5f + this.field_78116_c.field_78796_g;
            this.func_187074_a((HandSide)side).field_78795_f = -1.5707964f + this.field_78116_c.field_78795_f;
            this.func_187074_a((HandSide)opposide).field_78795_f = -1.5707964f + this.field_78116_c.field_78795_f;
        } else if (this.armsPose == HumanoidArmPose.CANNON_HOLDING) {
            this.field_178723_h.field_78796_g = 1.2f;
            this.field_178724_i.field_78796_g = 0.8f;
            this.field_178723_h.field_78795_f = -2.243995f;
            this.field_178724_i.field_78795_f = -1.7453294f;
        }
        if (Minecraft.func_71410_x().func_147113_T()) {
            return;
        }
        if (((OPEntity)entity).getAnimation() == OPEntity.Animation.CLEAVE_ATTACK.getId()) {
            if (this.animationTimer < 5.0f) {
                this.animationTimer = (float)((double)this.animationTimer + 0.15);
            }
            this.field_178723_h.field_78795_f = -1.3f + (float)Math.sin(this.animationTimer / 1.0f);
            this.field_178723_h.field_78796_g = -0.3f;
            this.field_178723_h.field_78808_h = 1.5f;
        } else if (((OPEntity)entity).getAnimation() == OPEntity.Animation.SHOCKWAVE.getId()) {
            if (this.animationTimer < 3.0f) {
                this.animationTimer = (float)((double)this.animationTimer + 0.1);
            }
            this.field_178723_h.field_78795_f = -1.5f - (float)Math.sin(this.animationTimer * 2.0f) * 2.0f;
            this.field_178723_h.field_78796_g = 0.0f;
            this.field_178723_h.field_78808_h = 0.0f;
        } else if (((OPEntity)entity).getAnimation() <= OPEntity.Animation.NONE.getId()) {
            this.animationTimer = 0.0f;
        }
    }

    public void func_225599_a_(HandSide side, MatrixStack matrixStack) {
        super.func_225599_a_(side, matrixStack);
        if (this.armsPose == HumanoidArmPose.FLINTLOCK_POINTING) {
            matrixStack.func_227861_a_(0.3, 0.15, 0.0);
            matrixStack.func_227863_a_(new Quaternion(Vector3f.field_229183_f_, 20.0f, true));
        } else if (this.armsPose == HumanoidArmPose.SENRIKU_HOLDING) {
            matrixStack.func_227861_a_(-0.3, 0.7, 0.0);
            matrixStack.func_227863_a_(new Quaternion(Vector3f.field_229181_d_, -75.0f, true));
            matrixStack.func_227863_a_(new Quaternion(Vector3f.field_229179_b_, -90.0f, true));
        } else if (this.armsPose == HumanoidArmPose.SENRIKU_POINTING) {
            matrixStack.func_227861_a_(0.05, 0.15, 0.0);
            matrixStack.func_227863_a_(new Quaternion(Vector3f.field_229179_b_, 5.0f, true));
        } else if (this.armsPose == HumanoidArmPose.CANNON_HOLDING) {
            matrixStack.func_227861_a_(-0.1, -0.15, -0.25);
            matrixStack.func_227863_a_(new Quaternion(Vector3f.field_229179_b_, 35.0f, true));
            matrixStack.func_227863_a_(new Quaternion(Vector3f.field_229183_f_, -75.0f, true));
            matrixStack.func_227862_a_(1.25f, 1.25f, 1.25f);
        }
    }

    public void setRotationAngle(ModelRenderer modelRenderer, float x, float y, float z) {
        modelRenderer.field_78795_f = x;
        modelRenderer.field_78796_g = y;
        modelRenderer.field_78808_h = z;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static enum HumanoidArmPose {
        EMPTY,
        FLINTLOCK_POINTING,
        SENRIKU_HOLDING,
        SENRIKU_POINTING,
        CANNON_HOLDING;

    }
}

