/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.packets.client.crew;

import java.util.function.Supplier;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import xyz.pixelatedw.mineminenomi.api.crew.Crew;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.data.world.ExtendedWorldData;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.packets.server.SSyncWorldDataPacket;
import xyz.pixelatedw.mineminenomi.wypi.network.WyNetwork;

public class CCreateCrewPacket {
    private String name;

    public CCreateCrewPacket() {
    }

    public CCreateCrewPacket(String name) {
        this.name = name;
    }

    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.name.length());
        buffer.func_180714_a(this.name);
    }

    public static CCreateCrewPacket decode(PacketBuffer buffer) {
        CCreateCrewPacket msg = new CCreateCrewPacket();
        int len = buffer.readInt();
        msg.name = buffer.func_150789_c(len);
        return msg;
    }

    public static void handle(CCreateCrewPacket message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_SERVER) {
            ctx.get().enqueueWork(() -> {
                ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
                ExtendedWorldData worldProps = ExtendedWorldData.get(player.field_70170_p);
                Crew crew = new Crew(message.name, (LivingEntity)player);
                worldProps.addCrew(crew);
                crew.create(player.field_70170_p);
                if (CommonConfig.INSTANCE.isCrewWorldMessageEnabled()) {
                    TranslationTextComponent newCrewMsg = new TranslationTextComponent(ModI18n.CREW_MESSAGE_NEW_CREW, new Object[]{message.name});
                    for (PlayerEntity target : player.field_70170_p.func_217369_A()) {
                        target.func_145747_a((ITextComponent)new StringTextComponent(TextFormatting.GOLD + newCrewMsg.func_150254_d()));
                    }
                }
                WyNetwork.sendToAll(new SSyncWorldDataPacket(worldProps));
            });
        }
        ctx.get().setPacketHandled(true);
    }
}

