/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.packets.client.trade;

import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import xyz.pixelatedw.mineminenomi.api.helpers.CurrencyHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.entities.mobs.SkypieanTraderEntity;
import xyz.pixelatedw.mineminenomi.packets.server.SSyncEntityStatsPacket;
import xyz.pixelatedw.mineminenomi.wypi.network.WyNetwork;

public class CSellToTraderPacket {
    private int traderId;
    private int amount;

    public CSellToTraderPacket() {
    }

    public CSellToTraderPacket(int traderId, int amount) {
        this.traderId = traderId;
        this.amount = amount;
    }

    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.traderId);
        buffer.writeInt(this.amount);
    }

    public static CSellToTraderPacket decode(PacketBuffer buffer) {
        CSellToTraderPacket msg = new CSellToTraderPacket();
        msg.traderId = buffer.readInt();
        msg.amount = buffer.readInt();
        return msg;
    }

    public static void handle(CSellToTraderPacket message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_SERVER) {
            ctx.get().enqueueWork(() -> {
                ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
                Entity target = player.field_70170_p.func_73045_a(message.traderId);
                if (target != null && target instanceof SkypieanTraderEntity) {
                    SkypieanTraderEntity trader = (SkypieanTraderEntity)target;
                    IEntityStats entityData = EntityStatsCapability.get((LivingEntity)player);
                    int dirtBlocksAvailable = 0;
                    ArrayList<Object> markedStacks = new ArrayList<Object>();
                    for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                        ItemStack stack = player.field_71071_by.func_70301_a(i);
                        if (stack == null || stack.func_190926_b() || stack.func_77973_b() != Blocks.field_150346_d.func_199767_j()) continue;
                        dirtBlocksAvailable += stack.func_190916_E();
                        if (markedStacks.contains(stack)) continue;
                        markedStacks.add(stack);
                    }
                    if ((dirtBlocksAvailable = MathHelper.func_76125_a((int)dirtBlocksAvailable, (int)0, (int)message.amount)) >= message.amount) {
                        int markedBlocks = dirtBlocksAvailable;
                        for (ItemStack itemStack : markedStacks) {
                            if (markedBlocks <= 0) break;
                            int stackSize = itemStack.func_190916_E();
                            if (markedBlocks - stackSize >= 0) {
                                markedBlocks -= stackSize;
                                itemStack.func_190918_g(stackSize);
                                continue;
                            }
                            int blocksNeeded = markedBlocks;
                            markedBlocks -= blocksNeeded;
                            itemStack.func_190918_g(blocksNeeded);
                        }
                        trader.removeTradesLeft(message.amount);
                        long value = CurrencyHelper.getExtolFromBelly(dirtBlocksAvailable);
                        entityData.alterExtol(value);
                        WyNetwork.sendTo(new SSyncEntityStatsPacket(player.func_145782_y(), entityData), (PlayerEntity)player);
                    }
                }
            });
        }
        ctx.get().setPacketHandled(true);
    }
}

