/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.packets.server;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;

public class SSyncEntityStatsPacket {
    private int entityId;
    private INBT data;

    public SSyncEntityStatsPacket() {
    }

    public SSyncEntityStatsPacket(int entityId, IEntityStats props) {
        this.data = new CompoundNBT();
        this.data = EntityStatsCapability.INSTANCE.getStorage().writeNBT(EntityStatsCapability.INSTANCE, (Object)props, null);
        this.entityId = entityId;
    }

    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.entityId);
        buffer.func_150786_a((CompoundNBT)this.data);
    }

    public static SSyncEntityStatsPacket decode(PacketBuffer buffer) {
        SSyncEntityStatsPacket msg = new SSyncEntityStatsPacket();
        msg.entityId = buffer.readInt();
        msg.data = buffer.func_150793_b();
        return msg;
    }

    public static void handle(SSyncEntityStatsPacket message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            ctx.get().enqueueWork(() -> ClientHandler.handle(message));
        }
        ctx.get().setPacketHandled(true);
    }

    public static class ClientHandler {
        @OnlyIn(value=Dist.CLIENT)
        public static void handle(SSyncEntityStatsPacket message) {
            Entity target = Minecraft.func_71410_x().field_71441_e.func_73045_a(message.entityId);
            if (target == null || !(target instanceof LivingEntity)) {
                return;
            }
            IEntityStats props = EntityStatsCapability.get((LivingEntity)target);
            EntityStatsCapability.INSTANCE.getStorage().readNBT(EntityStatsCapability.INSTANCE, (Object)props, null, message.data);
            if (CommonConfig.INSTANCE.isExtraHeartsEnabled()) {
                IAttributeInstance maxHpAttribute = ((LivingEntity)target).func_110148_a(SharedMonsterAttributes.field_111267_a);
                if (props.getDoriki() / 100 <= 20) {
                    maxHpAttribute.func_111128_a(20.0);
                } else {
                    maxHpAttribute.func_111128_a((double)(props.getDoriki() / 100));
                }
            }
        }
    }
}

