/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.particles;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.TexturedParticle;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.Quaternion;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import xyz.pixelatedw.mineminenomi.config.ClientConfig;
import xyz.pixelatedw.mineminenomi.particles.CustomParticleRenderType;
import xyz.pixelatedw.mineminenomi.particles.data.GenericParticleData;

@OnlyIn(value=Dist.CLIENT)
public class SimpleParticle
extends TexturedParticle {
    private static final ImmutableList<VertexFormatElement> ELEMENTS = ImmutableList.of((Object)DefaultVertexFormats.field_181713_m, (Object)DefaultVertexFormats.field_181715_o, (Object)DefaultVertexFormats.field_181714_n, (Object)DefaultVertexFormats.field_181717_q, (Object)DefaultVertexFormats.field_181718_r);
    public static final VertexFormat VERTEX_FORMAT = new VertexFormat(ELEMENTS);
    private boolean hasRotation = false;
    private boolean hasMotionDecay = true;
    private IParticleRenderType type;

    public SimpleParticle(IParticleRenderType type, World world, double posX, double posY, double posZ, double motionX, double motionY, double motionZ) {
        super(world, posX, posY, posZ, 0.0, 0.0, 0.0);
        this.field_70547_e = 30 + this.field_187136_p.nextInt(10);
        this.field_70546_d = 0;
        this.field_70544_f = 0.2f;
        this.field_70545_g = 0.0f;
        this.func_70538_b(1.0f, 1.0f, 1.0f);
        this.field_190017_n = false;
        this.type = type;
        this.field_187129_i = motionX;
        this.field_187130_j = motionY;
        this.field_187131_k = motionZ;
    }

    public void func_189213_a() {
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
        if (this.field_70545_g != 0.0f) {
            this.field_187130_j = -0.04 * (double)this.field_70545_g;
        }
        this.func_187110_a(this.field_187129_i, this.field_187130_j, this.field_187131_k);
        if (this.hasMotionDecay) {
            this.field_187129_i *= 0.99;
            this.field_187130_j *= 0.99;
            this.field_187131_k *= 0.99;
        }
        if (this.field_70546_d >= this.field_70547_e / 2 && this.field_70544_f > 0.0f) {
            this.field_70544_f /= 1.1f;
        }
        if (this.field_70546_d + 5 >= this.field_70547_e && this.field_82339_as > 0.0f) {
            this.field_82339_as = (float)((double)this.field_82339_as / 1.15);
        }
        if (this.hasRotation) {
            this.field_190014_F -= 0.3f;
        }
        if (this.field_70546_d++ >= this.field_70547_e || this.field_187132_l) {
            this.func_187112_i();
        }
    }

    public void func_225606_a_(IVertexBuilder buffer, ActiveRenderInfo renderInfo, float partialTicks) {
        Quaternion quaternion;
        Vec3d vec3d = renderInfo.func_216785_c();
        float f = (float)(MathHelper.func_219803_d((double)partialTicks, (double)this.field_187123_c, (double)this.field_187126_f) - vec3d.func_82615_a());
        float f1 = (float)(MathHelper.func_219803_d((double)partialTicks, (double)this.field_187124_d, (double)this.field_187127_g) - vec3d.func_82617_b());
        float f2 = (float)(MathHelper.func_219803_d((double)partialTicks, (double)this.field_187125_e, (double)this.field_187128_h) - vec3d.func_82616_c());
        if (this.field_190014_F == 0.0f) {
            quaternion = renderInfo.func_227995_f_();
        } else {
            quaternion = new Quaternion(renderInfo.func_227995_f_());
            quaternion.func_195890_a(Vector3f.field_229181_d_.func_229193_c_(this.field_190014_F));
        }
        Vector3f vector3f1 = new Vector3f(-1.0f, -1.0f, 0.0f);
        vector3f1.func_214905_a(quaternion);
        Vector3f[] avector3f = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        float scale = this.func_217561_b(partialTicks);
        for (int i = 0; i < 4; ++i) {
            Vector3f vector3f = avector3f[i];
            vector3f.func_214905_a(quaternion);
            vector3f.func_195898_a(scale);
            vector3f.func_195904_b(f, f1, f2);
        }
        float minU = this.func_217563_c();
        float maxU = this.func_217564_d();
        float minV = this.func_217562_e();
        float maxV = this.func_217560_f();
        int brightness = this.func_189214_a(partialTicks);
        buffer.func_225582_a_((double)avector3f[0].func_195899_a(), (double)avector3f[0].func_195900_b(), (double)avector3f[0].func_195902_c()).func_225583_a_(maxU, maxV).func_227885_a_(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_227886_a_(brightness).func_181675_d();
        buffer.func_225582_a_((double)avector3f[1].func_195899_a(), (double)avector3f[1].func_195900_b(), (double)avector3f[1].func_195902_c()).func_225583_a_(maxU, minV).func_227885_a_(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_227886_a_(brightness).func_181675_d();
        buffer.func_225582_a_((double)avector3f[2].func_195899_a(), (double)avector3f[2].func_195900_b(), (double)avector3f[2].func_195902_c()).func_225583_a_(minU, minV).func_227885_a_(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_227886_a_(brightness).func_181675_d();
        buffer.func_225582_a_((double)avector3f[3].func_195899_a(), (double)avector3f[3].func_195900_b(), (double)avector3f[3].func_195902_c()).func_225583_a_(minU, maxV).func_227885_a_(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_227886_a_(brightness).func_181675_d();
    }

    public SimpleParticle setParticleAlpha(float f) {
        this.func_82338_g(f);
        return this;
    }

    public SimpleParticle setParticleScale(float f) {
        this.field_70544_f = f;
        return this;
    }

    public SimpleParticle setParticleGravity(float f) {
        this.field_70545_g = f;
        return this;
    }

    public SimpleParticle setParticleAge(int i) {
        this.field_70547_e = i + this.field_187136_p.nextInt(10);
        return this;
    }

    public SimpleParticle setHasRotation() {
        this.hasRotation = true;
        return this;
    }

    public SimpleParticle setHasMotionDecay(boolean flag) {
        this.hasMotionDecay = flag;
        return this;
    }

    public BlockPos getPos() {
        return new BlockPos(this.field_187126_f, this.field_187127_g, this.field_187128_h);
    }

    public IParticleRenderType func_217558_b() {
        return this.type;
    }

    protected float func_217564_d() {
        return 1.0f;
    }

    protected float func_217560_f() {
        return 1.0f;
    }

    protected float func_217563_c() {
        return 0.0f;
    }

    protected float func_217562_e() {
        return 0.0f;
    }

    public static class Factory
    implements IParticleFactory<GenericParticleData> {
        private IParticleRenderType type;

        public Factory(ResourceLocation res) {
            this.type = new CustomParticleRenderType(res);
        }

        public Particle makeParticle(GenericParticleData data, World world, double posX, double posY, double posZ, double velX, double velY, double velZ) {
            SimpleParticle particle = new SimpleParticle(this.type, world, posX, posY, posZ, data.getMotionX(), data.getMotionY(), data.getMotionZ());
            particle.func_70538_b(data.getRed(), data.getGreen(), data.getBlue());
            particle.setParticleAlpha(data.getAlpha());
            particle.setParticleScale(data.getSize() / 10.0f);
            particle.setParticleAge(data.getLife());
            particle.setHasMotionDecay(data.hasMotionDecay());
            if (data.hasRotation()) {
                particle.setHasRotation();
            }
            if (Minecraft.func_71410_x().field_71439_g != null) {
                if (data.getEntityID() == (float)Minecraft.func_71410_x().field_71439_g.func_145782_y()) {
                    if (Minecraft.func_71410_x().field_71474_y.field_74320_O == 0 && data.getHideTooClose()) {
                        particle.setParticleAlpha((float)ClientConfig.INSTANCE.getFireVisibility() / 100.0f);
                    }
                } else if (data.getHideFromOthers()) {
                    particle.setParticleAlpha(0.0f);
                }
            }
            return particle;
        }
    }
}

