/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.particles.effects.suna;

import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.init.ModParticleTypes;
import xyz.pixelatedw.mineminenomi.particles.data.GenericParticleData;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class SablesParticleEffect
extends ParticleEffect {
    public float mult = 10.0f;
    int angle = 0;

    @Override
    public void spawn(World world, double posX, double posY, double posZ, double motionX, double motionY, double motionZ) {
        int maxHeight = 15 + (int)(10.0f * this.mult);
        double minRadius = 0.4 + 1.2 * (double)this.mult;
        double maxRadius = 1.0f + 3.0f * this.mult;
        int lines = 12;
        double heightIncrease = 0.15;
        double radiusIncrement = maxRadius / (double)maxHeight * (double)(1.0f - this.mult / 2.0f);
        for (int l = 0; l < lines; ++l) {
            for (double y = 0.0; y < (double)maxHeight; y += heightIncrease) {
                double radius = y * radiusIncrement;
                double v = (double)(360.0f / (float)lines * (float)l) + y * 25.0;
                double x = Math.cos(Math.toRadians(v - (double)this.angle)) * Math.max(radius, minRadius);
                double z = Math.sin(Math.toRadians(v - (double)this.angle)) * Math.max(radius, minRadius);
                GenericParticleData data = new GenericParticleData(ModParticleTypes.SUNA2);
                data.setLife(10);
                data.setSize(0.25f + 1.5f * this.mult);
                data.setMotion(motionX, motionY + 0.1 - Math.abs(WyHelper.randomDouble() / 5.0), motionZ);
                WyHelper.spawnParticles(data, (ServerWorld)world, posX + x, posY + y, posZ + z);
            }
        }
        this.angle += 2;
    }
}

