/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.quests.objectives;

import javax.annotation.Nullable;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.DamageSource;
import xyz.pixelatedw.mineminenomi.api.quests.objectives.IHitEntityObjective;
import xyz.pixelatedw.mineminenomi.api.quests.objectives.Objective;

public class HitEntityObjective
extends Objective
implements IHitEntityObjective {
    protected ICheckHit hitEvent = (player, target, source, amount) -> true;

    public HitEntityObjective(String title, int count) {
        this(title, count, (ICheckHit)null);
    }

    public HitEntityObjective(String title, int count, EntityType entityType) {
        this(title, count, (PlayerEntity player, LivingEntity target, DamageSource source, float amount) -> target.func_200600_R() == entityType);
    }

    public HitEntityObjective(String title, int count, @Nullable ICheckHit check) {
        super(title);
        this.setMaxProgress(count);
        if (check != null) {
            this.hitEvent = check;
        }
    }

    @Override
    public boolean checkHit(PlayerEntity player, LivingEntity target, DamageSource source, float amount) {
        return this.hitEvent.test(player, target, source, amount);
    }

    @FunctionalInterface
    public static interface ICheckHit {
        public boolean test(PlayerEntity var1, LivingEntity var2, DamageSource var3, float var4);

        default public ICheckHit and(ICheckHit check) {
            return (player, target, source, amount) -> this.test(player, target, source, amount) && check.test(player, target, source, amount);
        }

        default public ICheckHit or(ICheckHit check) {
            return (player, target, source, amount) -> this.test(player, target, source, amount) || check.test(player, target, source, amount);
        }
    }
}

