/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.renderers.entities;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.BipedRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.BipedArmorLayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.entity.MobEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import xyz.pixelatedw.mineminenomi.entities.mobs.IDynamicRenderer;
import xyz.pixelatedw.mineminenomi.entities.mobs.OPEntity;
import xyz.pixelatedw.mineminenomi.init.ModWeapons;
import xyz.pixelatedw.mineminenomi.models.entities.mobs.humanoids.HumanoidModel;
import xyz.pixelatedw.mineminenomi.renderers.layers.AuraLayer;
import xyz.pixelatedw.mineminenomi.renderers.layers.BodyCoatingLayer;
import xyz.pixelatedw.mineminenomi.renderers.layers.HandcuffsLayer;
import xyz.pixelatedw.mineminenomi.renderers.layers.PotionLayer;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

@OnlyIn(value=Dist.CLIENT)
public class HumanoidRenderer<T extends MobEntity, M extends BipedModel<T>>
extends BipedRenderer<T, M> {
    protected ResourceLocation texture;
    protected float[] scale;

    public HumanoidRenderer(EntityRendererManager manager, M model) {
        this(manager, model, null);
    }

    public HumanoidRenderer(EntityRendererManager manager, M model, String tex) {
        this(manager, model, new float[]{1.0f, 1.0f, 1.0f}, tex);
    }

    public HumanoidRenderer(EntityRendererManager manager, M model, float[] scale, String tex) {
        super(manager, model, (float)(0.5 * Math.pow(scale[0], 1.5)));
        this.scale = scale;
        this.texture = new ResourceLocation("mineminenomi", "textures/models/" + tex + ".png");
        this.func_177094_a(new BodyCoatingLayer((IEntityRenderer)this));
        this.func_177094_a((LayerRenderer)new BipedArmorLayer((IEntityRenderer)this, new BipedModel(0.5f), new BipedModel(1.0f)));
        this.func_177094_a(new PotionLayer((IEntityRenderer)this));
        this.func_177094_a(new AuraLayer((IEntityRenderer)this));
        this.func_177094_a(new HandcuffsLayer((IEntityRenderer)this));
    }

    public void preRenderCallback(T entity, MatrixStack matrixStack, float partialTickTime) {
        matrixStack.func_227862_a_(this.scale[0], this.scale[1], this.scale[2]);
    }

    public void func_225623_a_(T entity, float entityYaw, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int packedLight) {
        super.func_225623_a_(entity, entityYaw, partialTicks, matrixStack, buffer, packedLight);
        if (entity instanceof OPEntity && this.func_217764_d() instanceof HumanoidModel) {
            ItemStack mainItemStack = entity.func_184582_a(EquipmentSlotType.MAINHAND);
            HumanoidModel model = (HumanoidModel)this.func_217764_d();
            int animation = ((OPEntity)entity).getAnimation();
            model.armsPose = HumanoidModel.HumanoidArmPose.EMPTY;
            if (mainItemStack.func_77973_b() == ModWeapons.FLINTLOCK && animation == OPEntity.Animation.FLINTLOCK_POINTING.ordinal()) {
                model.armsPose = HumanoidModel.HumanoidArmPose.FLINTLOCK_POINTING;
            }
            if (mainItemStack.func_77973_b() == ModWeapons.SENRIKU) {
                model.armsPose = HumanoidModel.HumanoidArmPose.SENRIKU_HOLDING;
                if (animation == OPEntity.Animation.FLINTLOCK_POINTING.ordinal()) {
                    model.armsPose = HumanoidModel.HumanoidArmPose.SENRIKU_POINTING;
                }
            }
            if (mainItemStack.func_77973_b() == ModWeapons.BAZOOKA) {
                model.armsPose = HumanoidModel.HumanoidArmPose.CANNON_HOLDING;
            }
        }
    }

    protected void applyRotations(T entityLiving, MatrixStack matrixStack, float ageInTicks, float rotationYaw, float partialTicks) {
        super.func_225621_a_(entityLiving, matrixStack, ageInTicks, rotationYaw, partialTicks);
    }

    public ResourceLocation func_110775_a(T entity) {
        if (this.texture == null && entity instanceof IDynamicRenderer || this.texture.equals((Object)new ResourceLocation("mineminenomi:textures/models/null.png"))) {
            String textureName = ((IDynamicRenderer)entity).getMobTexture();
            if (WyHelper.isNullOrEmpty(textureName)) {
                textureName = ((IDynamicRenderer)entity).getDefaultTexture();
            }
            return new ResourceLocation("mineminenomi", "textures/models/" + textureName + ".png");
        }
        return this.texture;
    }

    public static class Factory
    implements IRenderFactory {
        protected BipedModel model;
        private float[] scale;
        private String texture;

        public Factory(BipedModel model, float scale) {
            this(model, scale, scale, scale, null);
        }

        public Factory(BipedModel model, float scale, String texture) {
            this(model, scale, scale, scale, texture);
        }

        public Factory(BipedModel model, float scaleX, float scaleY, float scaleZ) {
            this(model, scaleX, scaleY, scaleZ, null);
        }

        public Factory(BipedModel model, float scaleX, float scaleY, float scaleZ, String texture) {
            this.model = model;
            this.texture = texture;
            this.scale = new float[]{scaleX, scaleY, scaleZ};
        }

        public EntityRenderer createRenderFor(EntityRendererManager manager) {
            return new HumanoidRenderer(manager, this.model, this.scale, this.texture);
        }
    }
}

