/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.EnchantmentNameParts;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.gui.GuiUtils;
import xyz.pixelatedw.mineminenomi.api.quests.Quest;
import xyz.pixelatedw.mineminenomi.api.quests.objectives.Objective;
import xyz.pixelatedw.mineminenomi.data.entity.quests.IQuestData;
import xyz.pixelatedw.mineminenomi.data.entity.quests.QuestDataCapability;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.init.ModResources;
import xyz.pixelatedw.mineminenomi.packets.client.quest.CAbandonQuestPacket;
import xyz.pixelatedw.mineminenomi.packets.client.quest.CStartObjectiveEventPacket;
import xyz.pixelatedw.mineminenomi.screens.extra.TexturedIconButton;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.debug.WyDebug;
import xyz.pixelatedw.mineminenomi.wypi.network.WyNetwork;

@OnlyIn(value=Dist.CLIENT)
public class QuestsTrackerScreen
extends Screen {
    private PlayerEntity player;
    private IQuestData qprops;
    private int questIndex = 0;
    private List<String> hiddenTexts = new ArrayList<String>();
    private Quest currentQuest = null;
    private List<Quest> availableQuests;

    public QuestsTrackerScreen(PlayerEntity player) {
        super((ITextComponent)new StringTextComponent(""));
        this.player = player;
        this.qprops = QuestDataCapability.get(player);
        this.availableQuests = Arrays.asList(this.qprops.getInProgressQuests()).stream().filter(quest -> quest != null).collect(Collectors.toList());
    }

    public void render(int x, int y, float f) {
        this.renderBackground();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int posX = this.width / 2;
        int posY = this.height / 2;
        Minecraft.func_71410_x().func_110434_K().func_110577_a(ModResources.BLANK);
        RenderSystem.pushMatrix();
        double scale = 1.1;
        RenderSystem.translated((double)(posX - 35), (double)(posY + 10), (double)0.0);
        RenderSystem.translated((double)256.0, (double)256.0, (double)0.0);
        RenderSystem.scaled((double)(scale * 1.5), (double)(scale * 1.4), (double)0.0);
        RenderSystem.translated((double)-256.0, (double)-256.0, (double)0.0);
        GuiUtils.drawTexturedModalRect((int)0, (int)0, (int)0, (int)0, (int)256, (int)256, (float)1.0f);
        RenderSystem.translated((double)-30.0, (double)50.0, (double)0.0);
        RenderSystem.translated((double)256.0, (double)256.0, (double)0.0);
        RenderSystem.scaled((double)(scale * 0.7), (double)(scale * 0.9), (double)0.0);
        RenderSystem.translated((double)-256.0, (double)-256.0, (double)0.0);
        RenderSystem.popMatrix();
        String currentQuestName = this.currentQuest != null ? new TranslationTextComponent(String.format("quest.mineminenomi.%s", this.currentQuest.getId()), new Object[0]).func_150254_d() : "None";
        double currentQuestProgress = this.currentQuest != null ? this.currentQuest.getProgress() * 100.0 : -1.0;
        RenderSystem.translated((double)0.0, (double)10.0, (double)0.0);
        if (this.currentQuest != null) {
            RenderSystem.pushMatrix();
            RenderSystem.translated((double)(posX + 150), (double)(posY - 110), (double)0.0);
            String pageNumber = this.questIndex + 1 + "/" + this.availableQuests.size();
            WyHelper.drawStringWithBorder(this.font, pageNumber, 0, 0, WyHelper.hexToRGB("#FFFFFF").getRGB());
            RenderSystem.popMatrix();
            RenderSystem.pushMatrix();
            double scale2 = 1.4;
            RenderSystem.translated((double)(posX + 100), (double)(posY + 10), (double)0.0);
            RenderSystem.translated((double)256.0, (double)256.0, (double)0.0);
            RenderSystem.scaled((double)scale2, (double)scale2, (double)0.0);
            RenderSystem.translated((double)-256.0, (double)-256.0, (double)0.0);
            WyHelper.drawStringWithBorder(this.font, currentQuestName, -this.font.func_78256_a(currentQuestName) / 2, 0, WyHelper.hexToRGB("#FFFFFF").getRGB());
            RenderSystem.popMatrix();
            if (currentQuestProgress != -1.0) {
                String textColor = "#FFFFFF";
                if (this.currentQuest.isComplete()) {
                    textColor = "#00FF55";
                }
                String progress = TextFormatting.BOLD + new TranslationTextComponent(ModI18n.GUI_QUEST_PROGRESS, new Object[0]).func_150254_d() + " : " + String.format("%.1f", currentQuestProgress) + "%";
                WyHelper.drawStringWithBorder(this.font, progress, posX - 120, posY - 65, WyHelper.hexToRGB(textColor).getRGB());
            }
            RenderSystem.pushMatrix();
            List avilableObjectives = this.currentQuest.getObjectives().stream().limit(5L).collect(Collectors.toList());
            int yOffset = -20;
            int i = 0;
            for (Objective obj : avilableObjectives) {
                String objectiveName = obj.getLocalizedTitle();
                String progress = "";
                double objectiveProgress = obj.getProgress() / obj.getMaxProgress() * 100.0;
                List hiddenObjs = avilableObjectives.stream().filter(o -> o.isHidden()).collect(Collectors.toList());
                yOffset += 20;
                String textColor = "#FFFFFF";
                if (obj.isComplete()) {
                    textColor = "#00FF00";
                }
                if (obj.isLocked()) {
                    textColor = "#505050";
                } else {
                    progress = " - " + String.format("%.1f", objectiveProgress) + "%";
                }
                if (obj.isHidden()) {
                    FontRenderer galacticFont = this.minecraft.func_211500_ak().func_211504_a(Minecraft.field_71464_q);
                    WyHelper.drawStringWithBorder(this.font, "\u2022 ", posX - 130, posY - 45 + yOffset, WyHelper.hexToRGB(textColor).getRGB());
                    if (hiddenObjs.size() > 0) {
                        WyHelper.drawStringWithBorder(galacticFont, this.hiddenTexts.get(hiddenObjs.indexOf(obj)), posX - 123, posY - 45 + yOffset, WyHelper.hexToRGB(textColor).getRGB());
                    }
                } else {
                    String optional = obj.isOptional() ? "(Optional) " : "";
                    objectiveName = "\u2022 " + optional + "" + objectiveName + " " + progress;
                    List<String> splitText = WyHelper.splitString(this.font, objectiveName, posX, 210);
                    for (int j = 0; j < splitText.size(); ++j) {
                        WyHelper.drawStringWithBorder(this.font, splitText.get(j), posX - 130, posY - 45 + yOffset + j * 12, WyHelper.hexToRGB(textColor).getRGB());
                    }
                    yOffset += splitText.size() * 8;
                }
                ++i;
            }
            if (i == 0) {
                WyHelper.drawStringWithBorder(this.font, new TranslationTextComponent(ModI18n.TRAINER_NO_OBJECTIVES_LEFT, new Object[0]).func_150254_d(), posX - 120, posY - 20 + yOffset, WyHelper.hexToRGB("#FFFFFF").getRGB());
            }
            RenderSystem.popMatrix();
            RenderSystem.translated((double)0.0, (double)20.0, (double)0.0);
        }
        super.render(x, y, f);
    }

    public void init() {
        this.children.clear();
        this.buttons.clear();
        int posX = (this.width - 256) / 2;
        int posY = (this.height - 256) / 2;
        try {
            this.currentQuest = this.qprops.getInProgressQuests()[this.questIndex];
        }
        catch (Exception e) {
            if (this.qprops.getInProgressQuests().length > 0) {
                this.currentQuest = this.qprops.getInProgressQuests()[0];
                WyDebug.debug(String.format("\n[ArrayOutOfBounds] \n Max possible index is : %s \n But the index requested is : %s", this.qprops.getInProgressQuests().length - 1, this.questIndex));
            } else {
                this.currentQuest = null;
            }
            this.questIndex = 0;
            e.printStackTrace();
        }
        if (this.currentQuest == null) {
            return;
        }
        this.hiddenTexts.clear();
        for (Objective obj : this.currentQuest.getObjectives()) {
            if (!obj.isHidden()) continue;
            this.hiddenTexts.add(EnchantmentNameParts.func_178176_a().func_148334_a(Minecraft.func_71410_x().field_71466_p, obj.getTitle().length() * 2));
        }
        TexturedIconButton nextButton = new TexturedIconButton(ModResources.BIG_WOOD_BUTTON_RIGHT, posX + 285, posY + 80, 24, 100, "", btn -> {
            this.questIndex = this.questIndex + 1 < this.availableQuests.size() ? ++this.questIndex : 0;
            this.init();
        });
        nextButton = nextButton.setTextureInfo(posX + 280, posY + 35, 32, 128);
        if (this.availableQuests.size() <= 1) {
            nextButton.visible = false;
        }
        this.addButton((Widget)nextButton);
        TexturedIconButton prevButton = new TexturedIconButton(ModResources.BIG_WOOD_BUTTON_LEFT, posX - 55, posY + 80, 24, 100, "", btn -> {
            this.questIndex = this.questIndex > 0 ? --this.questIndex : this.availableQuests.size() - 1;
            this.init();
        });
        prevButton = prevButton.setTextureInfo(posX - 58, posY + 35, 32, 128);
        if (this.availableQuests.size() <= 1) {
            prevButton.visible = false;
        }
        this.addButton((Widget)prevButton);
        TexturedIconButton abandonQuestButton = new TexturedIconButton(ModResources.BLANK2_SIMPLE, posX - 40, posY + 210, 60, 30, "Abandon", btn -> {
            this.player.func_71053_j();
            if (this.currentQuest != null) {
                WyNetwork.sendToServer(new CAbandonQuestPacket(this.qprops.getInProgressQuestSlot(this.currentQuest)));
            }
        });
        abandonQuestButton = abandonQuestButton.setTextureInfo(posX - 40, posY + 180, 60, 40).setTextInfo(posX - 31, posY + 189, 1.0);
        this.addButton((Widget)abandonQuestButton);
        List avilableObjectives = this.currentQuest.getObjectives().stream().limit(5L).collect(Collectors.toList());
        int yOffset = -20;
        int objId = -1;
        for (Objective obj : avilableObjectives) {
            yOffset += 30;
            ++objId;
            if (!obj.hasEvent()) continue;
            String startText = obj.hasStartedEvent() ? "Restart Event" : "Start Event";
            int objId2 = objId;
            TexturedIconButton startEventButton = new TexturedIconButton(ModResources.BLANK2_SIMPLE, posX + 220, posY + 75 + yOffset, 60, 30, startText, btn -> {
                this.player.func_71053_j();
                if (this.currentQuest != null) {
                    WyNetwork.sendToServer(new CStartObjectiveEventPacket(this.qprops.getInProgressQuestSlot(this.currentQuest), objId2));
                }
            });
            int xOffset = obj.hasStartedEvent() ? 230 : 236;
            startEventButton = startEventButton.setTextureInfo(posX + 220, posY + 45 + yOffset, 60, 40).setTextInfo(posX + xOffset, posY + 56 + yOffset, 1.0);
            if (obj.isLocked()) {
                startEventButton.visible = false;
            }
            this.addButton((Widget)startEventButton);
        }
    }

    public boolean isPauseScreen() {
        return false;
    }
}

