/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.InventoryScreen;
import net.minecraft.client.gui.widget.ToggleWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.gui.GuiUtils;
import xyz.pixelatedw.mineminenomi.api.TradeEntry;
import xyz.pixelatedw.mineminenomi.api.entities.TraderEntity;
import xyz.pixelatedw.mineminenomi.api.enums.Currency;
import xyz.pixelatedw.mineminenomi.api.helpers.CurrencyHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.entities.mobs.SkypieanTraderEntity;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.init.ModKeybindings;
import xyz.pixelatedw.mineminenomi.init.ModResources;
import xyz.pixelatedw.mineminenomi.packets.client.CGiveItemStackPacket;
import xyz.pixelatedw.mineminenomi.packets.client.CSyncEntityStatsPacket;
import xyz.pixelatedw.mineminenomi.packets.client.trade.CSellToTraderPacket;
import xyz.pixelatedw.mineminenomi.packets.client.trade.CUpdateTraderOffersPacket;
import xyz.pixelatedw.mineminenomi.screens.extra.FlickeringString;
import xyz.pixelatedw.mineminenomi.screens.extra.ItemListScreenPanel;
import xyz.pixelatedw.mineminenomi.screens.extra.NewButton;
import xyz.pixelatedw.mineminenomi.screens.extra.SequencedString;
import xyz.pixelatedw.mineminenomi.screens.extra.TexturedIconButton;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.network.WyNetwork;

@OnlyIn(value=Dist.CLIENT)
public class TraderScreen
extends Screen {
    private int guiState = 0;
    private int wantedAmount = 1;
    private ItemListScreenPanel listPanel;
    private TradeEntry selectedStack;
    private TradeEntry hoveredStack;
    private PlayerEntity player;
    private TraderEntity trader;
    private IEntityStats props;
    private SequencedString startMessage;
    private FlickeringString skipMessage;
    private ToggleWidget vearthAmountUp;
    private ToggleWidget vearthAmountDown;
    private int dirtBlocksAvailable;
    protected static final ResourceLocation RECIPE_BOOK = new ResourceLocation("textures/gui/recipe_book.png");

    public TraderScreen(TraderEntity entity) {
        super((ITextComponent)new StringTextComponent(""));
        this.trader = entity;
        this.player = Minecraft.func_71410_x().field_71439_g;
        this.props = EntityStatsCapability.get((LivingEntity)this.player);
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        switch (this.guiState) {
            case 0: {
                this.renderMenu(mouseX, mouseY);
                break;
            }
            case 1: {
                this.renderSellShop(mouseX, mouseY, partialTicks);
                break;
            }
            case 2: {
                this.renderBuyShop(mouseX, mouseY, partialTicks);
            }
        }
        super.render(mouseX, mouseY, partialTicks);
    }

    public void renderMenu(int x, int y) {
        int posX = this.width / 2;
        int posY = this.height / 2;
        if (!this.trader.canBuyFromPlayers()) {
            this.startMessage.render(posX - 200, posY - 50);
            this.skipMessage.render(posX - 100, posY + 60);
            if (this.startMessage.ticksExisted > this.startMessage.delayTicks) {
                this.guiState = 1;
                this.init(this.getMinecraft(), this.width, this.height);
                if (this.trader.canTrade(this.player)) {
                    this.guiState = 1;
                    this.init(this.getMinecraft(), this.width, this.height);
                } else {
                    this.onClose();
                }
            }
        } else {
            this.startMessage.render(posX - 150, posY - 105);
        }
        RenderSystem.pushMatrix();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        InventoryScreen.func_228187_a_((int)(posX + 150), (int)(posY + 150), (int)100, (float)40.0f, (float)5.0f, (LivingEntity)this.trader);
        RenderSystem.popMatrix();
    }

    public void renderSellShop(int mouseX, int mouseY, float partialTicks) {
        this.getMinecraft().func_110434_K().func_110577_a(ModResources.BLANK2);
        int posX = this.width / 2;
        int posY = this.height / 2;
        GuiUtils.drawTexturedModalRect((int)(posX - 128), (int)(posY - 110), (int)0, (int)0, (int)256, (int)256, (float)0.0f);
        this.renderUpperColumn();
        this.drawSizedString(new TranslationTextComponent(ModI18n.GUI_NAME, new Object[0]).func_150254_d(), posX - 20, posY - 63, 0.9f, -1);
        this.drawSizedString(new TranslationTextComponent(ModI18n.GUI_PRICE, new Object[0]).func_150254_d(), posX + 50, posY - 63, 0.9f, -1);
        this.getMinecraft().func_110434_K().func_110577_a(ModResources.CURRENCIES);
        int type = this.trader.getCurrency() == Currency.BELLY ? 0 : 34;
        GuiUtils.drawTexturedModalRect((int)(posX + 53), (int)(posY - 76), (int)type, (int)32, (int)32, (int)64, (float)1.0f);
        this.listPanel.render(mouseX, mouseY, partialTicks);
        this.hover(mouseX, mouseY);
        if (this.selectedStack != null) {
            this.buttons.forEach(button -> button.render(mouseX, mouseY, partialTicks));
        }
    }

    public void renderBuyShop(int mouseX, int mouseY, float partialTicks) {
        int posX = this.width / 2;
        int posY = this.height / 2;
        this.startMessage.render(posX - 150, posY - 105);
        posX -= 110;
        if (this.trader instanceof SkypieanTraderEntity && ((SkypieanTraderEntity)this.trader).getTradesLeft() > 0) {
            this.renderItem(new ItemStack((IItemProvider)Blocks.field_150346_d.func_199767_j()), posX, posY - 30);
            String amount = this.wantedAmount + "";
            WyHelper.drawStringWithBorder(this.font, amount, posX + 8 - this.font.func_78256_a(amount) / 2, posY - 7, -1);
            WyHelper.drawStringWithBorder(this.font, "=", posX + 60, posY - 7, -1);
            WyHelper.drawStringWithBorder(this.font, CurrencyHelper.getExtolFromBelly(this.wantedAmount) + "", posX + 100, posY - 7, -1);
            this.getMinecraft().func_110434_K().func_110577_a(ModResources.CURRENCIES);
            GuiUtils.drawTexturedModalRect((int)(posX + 75), (int)(posY - 21), (int)34, (int)32, (int)32, (int)64, (float)1.0f);
        }
        RenderSystem.pushMatrix();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        InventoryScreen.func_228187_a_((int)((posX += 110) + 150), (int)(posY + 150), (int)100, (float)40.0f, (float)5.0f, (LivingEntity)this.trader);
        RenderSystem.popMatrix();
    }

    public void renderUpperColumn() {
        int posX = this.width / 2;
        int posY = this.height / 2;
        String amount = "";
        if (this.hoveredStack != null) {
            WyHelper.drawIcon(ModResources.BLANK, posX - 117, posY - 105, 32, 42);
            this.renderItem(this.hoveredStack.getItemStack(), posX - 110, posY - 100);
            amount = this.getWantedAmount() + "/" + this.hoveredStack.getCount();
            if (this.hoveredStack.hasInfiniteStock()) {
                amount = this.getWantedAmount() + "/\u221e";
            }
        } else if (this.getSelectedStack() != null) {
            WyHelper.drawIcon(ModResources.BLANK, posX - 117, posY - 105, 32, 42);
            this.renderItem(this.getSelectedStack().getItemStack(), posX - 110, posY - 100);
            amount = this.getWantedAmount() + "/" + this.getSelectedStack().getCount();
            if (this.getSelectedStack().hasInfiniteStock()) {
                amount = this.getWantedAmount() + "/\u221e";
            }
        }
        long currency = this.trader.getCurrency() == Currency.BELLY ? this.props.getBelly() : this.props.getExtol();
        this.drawSizedString(amount, posX - 70, posY - 100, 0.9f, -1);
        this.drawSizedString(currency + "", posX + 85, posY - 95, 0.9f, -1);
        this.getMinecraft().func_110434_K().func_110577_a(ModResources.CURRENCIES);
        int type = this.trader.getCurrency() == Currency.BELLY ? 0 : 34;
        GuiUtils.drawTexturedModalRect((int)(posX + 102), (int)(posY - 108), (int)type, (int)32, (int)32, (int)64, (float)1.0f);
    }

    public void init(Minecraft mc, int width, int height) {
        super.init(mc, width, height);
        int posX = this.width / 2;
        int posY = this.height / 2;
        this.startMessage = new SequencedString("", 0, 0);
        if (this.skipMessage == null) {
            this.skipMessage = new FlickeringString("- " + new TranslationTextComponent(ModI18n.GUI_CLICK_TO_SKIP, new Object[0]).func_150254_d() + " -", 20);
        }
        if (this.guiState == 0) {
            this.wantedAmount = 1;
            String message = "";
            message = this.trader.canTrade(this.player) ? new TranslationTextComponent(ModI18n.TRADER_WELCOME_MESSAGE, new Object[0]).func_150254_d() : this.trader.getTradeFailMessage();
            this.startMessage = new SequencedString(message, 250, this.font.func_78256_a(message) / 2);
            if (this.trader.canBuyFromPlayers()) {
                NewButton buyButton = new NewButton(posX - 180, posY - 50, 100, 20, I18n.func_135052_a((String)"gui.buy", (Object[])new Object[0]), btn -> {
                    this.guiState = 1;
                    this.init(this.getMinecraft(), this.width, this.height);
                });
                this.addButton((Widget)buyButton);
                NewButton sellButton = new NewButton(posX - 180, posY - 20, 100, 20, I18n.func_135052_a((String)"gui.sell", (Object[])new Object[0]), btn -> {
                    this.guiState = 2;
                    this.init(this.getMinecraft(), this.width, this.height);
                });
                this.addButton((Widget)sellButton);
            }
        } else if (this.guiState == 1) {
            this.listPanel = new ItemListScreenPanel(this, this.trader.getTradingItems());
            this.children.add(this.listPanel);
            TexturedIconButton incQtyBtn = new TexturedIconButton(ModResources.BRIGHT_WOOD_ARROW, posX - 50, posY - 105, 10, 32, "", this::onIncreaseQuantity);
            incQtyBtn = incQtyBtn.setTextureInfo(posX - 62, posY - 105, 32, 32);
            this.addButton((Widget)incQtyBtn);
            TexturedIconButton decQtyBtn = new TexturedIconButton(ModResources.BRIGHT_WOOD_ARROW_DOWN, posX - 30, posY - 109, 10, 32, "", this::onDecreaseQuantity);
            decQtyBtn = decQtyBtn.setTextureInfo(posX - 42, posY - 109, 32, 32);
            this.addButton((Widget)decQtyBtn);
            TexturedIconButton buyBtn = new TexturedIconButton(ModResources.BLANK, posX - 10, posY - 100, 64, 22, new TranslationTextComponent(ModI18n.GUI_BUY, new Object[0]).func_150254_d(), this::onBuy);
            buyBtn = buyBtn.setTextureInfo(posX - 10, posY - 100, 64, 32).setTextInfo(posX + 10, posY - 95, 1.0);
            this.addButton((Widget)buyBtn);
            if (this.trader.canBuyFromPlayers()) {
                NewButton backButton = new NewButton(posX - 200, posY + 78, 70, 20, I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0]), btn -> {
                    this.guiState = 0;
                    this.init(this.getMinecraft(), this.width, this.height);
                });
                this.addButton((Widget)backButton);
            }
        } else if (this.guiState == 2 && this.trader instanceof SkypieanTraderEntity) {
            this.wantedAmount = 0;
            SkypieanTraderEntity skypieanTrader = (SkypieanTraderEntity)this.trader;
            String message = new TranslationTextComponent(ModI18n.TRADER_SKYPIEAN_VEARTH, new Object[]{10000, skypieanTrader.getExtolLeftInStock()}).func_150254_d();
            if (skypieanTrader.getTradesLeft() <= 0) {
                message = new TranslationTextComponent(ModI18n.TRADER_SKYPIEAN_NO_EXTOL, new Object[0]).func_150254_d();
            }
            this.startMessage = new SequencedString(message, 250, this.font.func_78256_a(message) / 3, 5000000);
            if (skypieanTrader.getTradesLeft() > 0) {
                NewButton tradeButton = new NewButton(posX - 80, posY + 20, 70, 20, I18n.func_135052_a((String)"gui.sell", (Object[])new Object[0]), btn -> {
                    WyNetwork.sendToServer(new CSellToTraderPacket(this.trader.func_145782_y(), this.wantedAmount));
                    Minecraft.func_71410_x().func_147108_a(null);
                });
                this.addButton((Widget)tradeButton);
            }
            NewButton backButton = new NewButton(posX - 200, posY + 78, 70, 20, I18n.func_135052_a((String)"gui.cancel", (Object[])new Object[0]), btn -> {
                this.guiState = 0;
                this.init(this.getMinecraft(), this.width, this.height);
            });
            this.addButton((Widget)backButton);
            this.dirtBlocksAvailable = 0;
            for (int i = 0; i < this.player.field_71071_by.func_70302_i_(); ++i) {
                ItemStack stack = this.player.field_71071_by.func_70301_a(i);
                if (stack == null || stack.func_190926_b() || stack.func_77973_b() != Blocks.field_150346_d.func_199767_j()) continue;
                this.dirtBlocksAvailable += stack.func_190916_E();
            }
            this.vearthAmountUp = new ToggleWidget(posX - 80, posY - 11, 12, 17, false);
            this.vearthAmountUp.func_191751_a(1, 208, 13, 18, RECIPE_BOOK);
            this.vearthAmountDown = new ToggleWidget(posX - 135, posY - 11, 12, 17, true);
            this.vearthAmountDown.func_191751_a(1, 208, 13, 18, RECIPE_BOOK);
            if (skypieanTrader.getTradesLeft() > 0) {
                this.addButton((Widget)this.vearthAmountUp);
                this.addButton((Widget)this.vearthAmountDown);
            }
        }
    }

    public void onBuy(Button btn) {
        long currency;
        if (this.getSelectedStack() == null) {
            return;
        }
        if (this.getWantedAmount() > this.getSelectedStack().getCount() && !this.getSelectedStack().hasInfiniteStock()) {
            return;
        }
        if (this.getEmptySlots() < this.calculateSlotsFromCount(this.getWantedAmount())) {
            return;
        }
        int totalPrice = this.getSelectedStack().getPrice() * this.getWantedAmount();
        long l = currency = this.trader.getCurrency() == Currency.BELLY ? this.props.getBelly() : this.props.getExtol();
        if (currency < (long)totalPrice) {
            return;
        }
        ItemStack stack = new ItemStack((IItemProvider)this.getSelectedStack().getItemStack().func_77973_b());
        stack.func_190920_e(this.getWantedAmount());
        if (this.getSelectedStack().getItemStack().func_196082_o().func_74767_n("isClone")) {
            stack.func_196082_o().func_74757_a("isClone", true);
        }
        if (!this.getSelectedStack().hasInfiniteStock()) {
            int count = this.getSelectedStack().getCount() - this.wantedAmount;
            if (count <= 0) {
                this.trader.getTradingItems().remove(this.getSelectedStack());
            } else {
                this.getSelectedStack().setCount(count);
            }
            WyNetwork.sendToServer(new CUpdateTraderOffersPacket(this.trader.func_145782_y(), this.trader.getTradingItems()));
        }
        WyNetwork.sendToServer(new CGiveItemStackPacket(stack));
        this.player.field_71071_by.func_70441_a(stack);
        if (this.trader.getCurrency() == Currency.BELLY) {
            this.props.alterBelly(-totalPrice);
        } else if (this.trader.getCurrency() == Currency.EXTOL) {
            this.props.alterExtol(-totalPrice);
        }
        WyNetwork.sendToServer(new CSyncEntityStatsPacket(this.props));
        this.setSelectedStack(null);
    }

    public void onIncreaseQuantity(Button btn) {
        if (this.getSelectedStack() != null && (this.getWantedAmount() < this.getSelectedStack().getCount() || this.getSelectedStack().hasInfiniteStock())) {
            this.setWantedAmount(this.getWantedAmount() + 1);
        }
    }

    public void onDecreaseQuantity(Button btn) {
        if (this.getSelectedStack() != null && this.getWantedAmount() > 1) {
            this.setWantedAmount(this.getWantedAmount() - 1);
        }
    }

    public void renderItem(ItemStack stack, int posX, int posY) {
        Minecraft.func_71410_x().func_175599_af().func_180450_b(stack, posX, posY);
    }

    public void drawSizedString(String txt, int x, int y, float scale, int color) {
        RenderSystem.pushMatrix();
        RenderSystem.translated((double)x, (double)y, (double)0.0);
        RenderSystem.scalef((float)scale, (float)scale, (float)scale);
        if (color == -1) {
            color = WyHelper.hexToRGB("#FFFFFF").getRGB();
        }
        this.drawCenteredString(txt, 0, 0, color);
        RenderSystem.popMatrix();
    }

    public void hover(int mouseX, int mouseY) {
        TradeEntry entry = this.listPanel.findStackEntry(mouseX, mouseY);
        if (entry != null) {
            this.hoveredStack = entry;
            this.setWantedAmount(1);
        } else {
            this.hoveredStack = null;
        }
    }

    public int getEmptySlots() {
        int i = 0;
        for (ItemStack stack : this.player.field_71071_by.field_70462_a) {
            if (!stack.func_190926_b()) continue;
            ++i;
        }
        return i;
    }

    public int calculateSlotsFromCount(int count) {
        double val = (double)count / 64.0;
        return MathHelper.func_76143_f((double)val);
    }

    public List<Integer> getStacks(int count) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        int j = 0;
        for (int i = 0; i < count; i += 64) {
            if (count - 64 * j < 64) {
                list.add(count - 64 * j);
            } else {
                list.add(64);
            }
            ++j;
        }
        return list;
    }

    public void drawCenteredString(String txt, int posX, int posY, int color) {
        WyHelper.drawStringWithBorder(this.font, txt, posX - this.font.func_78256_a(txt) / 2, posY, color);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int partialTicks) {
        boolean flag = super.mouseClicked(mouseX, mouseY, partialTicks);
        if (this.guiState == 0 && !this.trader.canBuyFromPlayers()) {
            if (this.startMessage.ticksExisted < this.startMessage.maxTicks) {
                this.startMessage.ticksExisted = this.startMessage.maxTicks;
            } else if (this.trader.canTrade(this.player)) {
                this.guiState = 1;
                this.init(this.getMinecraft(), this.width, this.height);
            } else {
                this.onClose();
            }
        } else if (this.guiState == 2) {
            SkypieanTraderEntity skypieanTrader = (SkypieanTraderEntity)this.trader;
            if (this.vearthAmountUp.mouseClicked(mouseX, mouseY, partialTicks)) {
                int increaseAmount = 1;
                if (ModKeybindings.isShiftKeyDown()) {
                    increaseAmount = 10;
                }
                this.wantedAmount = this.wantedAmount + increaseAmount < skypieanTrader.getTradesLeft() ? (this.wantedAmount + increaseAmount <= this.dirtBlocksAvailable ? (this.wantedAmount += increaseAmount) : this.dirtBlocksAvailable) : skypieanTrader.getTradesLeft();
            } else if (this.vearthAmountDown.mouseClicked(mouseX, mouseY, partialTicks)) {
                int decreaseAmount = 1;
                if (ModKeybindings.isShiftKeyDown()) {
                    decreaseAmount = 10;
                }
                this.wantedAmount = this.wantedAmount - decreaseAmount >= 0 ? (this.wantedAmount -= decreaseAmount) : 0;
            }
        }
        return flag;
    }

    public TradeEntry getSelectedStack() {
        return this.selectedStack;
    }

    public void setSelectedStack(TradeEntry selectedStack) {
        this.selectedStack = selectedStack;
    }

    public int getWantedAmount() {
        return this.wantedAmount;
    }

    public void setWantedAmount(int wantedAmount) {
        this.wantedAmount = wantedAmount;
    }

    public static void open(TraderEntity entity) {
        Minecraft.func_71410_x().func_147108_a((Screen)new TraderScreen(entity));
    }
}

