/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.screens.extra;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.button.Button;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class NoTextureButton
extends Button {
    private boolean isSelected;
    private boolean isFake;
    private String onHoverTextColor = "#00FFBB";

    public NoTextureButton(int posX, int posY, int width, int height, String string, Button.IPressable onPress) {
        super(posX, posY, width, height, string, onPress);
    }

    public void setFake() {
        this.isFake = true;
    }

    public void setOnHoverTextColor(String color) {
        this.onHoverTextColor = color;
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        RenderSystem.pushMatrix();
        if (this.visible) {
            this.isHovered = mouseX >= this.x && mouseY >= this.y && mouseX < this.x + this.width && mouseY < this.y + this.height;
            int rgb = WyHelper.hexToRGB("#FFFFFF").getRGB();
            int topGrad = WyHelper.hexToRGB("#B3B3B3").getRGB();
            int bottomGrad = WyHelper.hexToRGB("#939393").getRGB();
            if (this.isHovered) {
                RenderSystem.translated((double)0.0, (double)0.5, (double)0.0);
                rgb = WyHelper.hexToRGB(this.onHoverTextColor).getRGB();
                topGrad = WyHelper.hexToRGB("#B3B3B3").getRGB();
                bottomGrad = WyHelper.hexToRGB("#505050").getRGB();
                if (this.isFake) {
                    topGrad = WyHelper.hexToRGB("#3333BB00").getRGB();
                    bottomGrad = WyHelper.hexToRGB("#000055FF").getRGB();
                    this.fillGradient(this.x, this.y, this.width + this.x, this.height + this.y, topGrad, bottomGrad);
                }
            }
            if (this.isSelected) {
                topGrad = WyHelper.hexToRGB("#00CC00").getRGB();
                bottomGrad = WyHelper.hexToRGB("#005500").getRGB();
            }
            int outlineSize = 1;
            if (!this.isFake) {
                this.fillGradient(this.x - outlineSize, this.y - outlineSize, this.width + this.x + outlineSize, this.height + this.y + outlineSize, WyHelper.hexToRGB("#000000").getRGB(), WyHelper.hexToRGB("#000000").getRGB());
                this.fillGradient(this.x, this.y, this.width + this.x, this.height + this.y, topGrad, bottomGrad);
                FontRenderer font = Minecraft.func_71410_x().field_71466_p;
                WyHelper.drawStringWithBorder(font, this.getMessage(), this.x - font.func_78256_a(this.getMessage()) / 2 + this.width / 2, this.y + this.height / 2 - 4, rgb);
            }
            RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
        }
        RenderSystem.popMatrix();
    }

    public void select() {
        this.isSelected = !this.isSelected;
    }
}

