/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.wypi.abilities;

import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import xyz.pixelatedw.mineminenomi.data.world.ExtendedWorldData;
import xyz.pixelatedw.mineminenomi.packets.server.ability.SUpdateEquippedAbilityPacket;
import xyz.pixelatedw.mineminenomi.wypi.APIConfig;
import xyz.pixelatedw.mineminenomi.wypi.abilities.ContinuousAbility;
import xyz.pixelatedw.mineminenomi.wypi.abilities.IParallelContinuousAbility;
import xyz.pixelatedw.mineminenomi.wypi.network.WyNetwork;

public abstract class RepeaterAbility
extends ContinuousAbility
implements IParallelContinuousAbility {
    private int repeaterCount;
    private int maxRepeaterCount;
    private int repeaterInterval;

    public RepeaterAbility(String name, APIConfig.AbilityCategory category) {
        super(name, category);
    }

    private void repeater(PlayerEntity player, int passiveTimer) {
        if (this.repeaterCount > 0 && passiveTimer % this.repeaterInterval == 0 && this.onUseEvent.onUse(player)) {
            --this.repeaterCount;
        }
    }

    public void setMaxRepeaterCount(int count, int interval) {
        this.repeaterCount = this.maxRepeaterCount = count;
        this.repeaterInterval = interval;
        int threshold = (int)Math.ceil((float)(this.repeaterCount * this.repeaterInterval) / 20.0f);
        this.setThreshold(threshold);
    }

    public void setRepeaterCount(int count) {
        this.repeaterCount = count;
    }

    public int getMaxRepeaterCount() {
        return this.maxRepeaterCount;
    }

    public int getRepeaterCount() {
        return this.repeaterCount;
    }

    public int getRepeaterInterval() {
        return this.repeaterInterval;
    }

    @Override
    public void use(PlayerEntity player) {
        super.use(player);
    }

    @Override
    public void tick(PlayerEntity player) {
        if (this.isContinuous()) {
            if (ExtendedWorldData.get(player.field_70170_p).isInsideRestrictedArea((int)player.func_226277_ct_(), (int)player.func_226278_cu_(), (int)player.func_226281_cx_())) {
                this.stopContinuity(player);
                return;
            }
            ++this.continueTime;
            if (!player.field_70170_p.field_72995_K) {
                this.duringContinuityEvent.duringContinuity(player, this.continueTime);
                this.repeater(player, this.continueTime);
            }
            if (this.getThreshold() > 0 && this.continueTime >= this.getThreshold()) {
                this.stopContinuity(player);
            }
        }
    }

    @Override
    public void stopContinuity(PlayerEntity player) {
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        if (this.onEndContinuityEvent.onEndContinuity(player)) {
            this.continueTime = 0;
            this.repeaterCount = this.maxRepeaterCount;
            this.startCooldown(player);
            WyNetwork.sendToAllTrackingAndSelf(new SUpdateEquippedAbilityPacket(player, this), (LivingEntity)player);
        }
    }
}

