/*
 * Decompiled with CFR 0.152.
 */
package com.maciej916.maessentials.client.interfaces;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.client.gui.GuiUtils;

public interface IGuiWrapper {
    default public void displayTooltip(ITextComponent component, int x, int y, int maxWidth) {
        this.displayTooltips(Collections.singletonList(component), x, y, maxWidth);
    }

    default public void displayTooltip(ITextComponent component, int x, int y) {
        this.displayTooltips(Collections.singletonList(component), x, y);
    }

    default public void displayTooltips(List<ITextComponent> components, int xAxis, int yAxis) {
        this.displayTooltips(components, xAxis, yAxis, -1);
    }

    default public void displayTooltips(List<ITextComponent> components, int xAxis, int yAxis, int maxWidth) {
        List toolTips = components.stream().map(ITextComponent::func_150254_d).collect(Collectors.toList());
        GuiUtils.drawHoveringText(toolTips, (int)xAxis, (int)yAxis, (int)this.getWidth(), (int)this.getHeight(), (int)maxWidth, (FontRenderer)this.getFont());
    }

    default public int getLeft() {
        if (this instanceof ContainerScreen) {
            return ((ContainerScreen)this).getGuiLeft();
        }
        return 0;
    }

    default public int getTop() {
        if (this instanceof ContainerScreen) {
            return ((ContainerScreen)this).getGuiTop();
        }
        return 0;
    }

    default public int getWidth() {
        if (this instanceof ContainerScreen) {
            return ((ContainerScreen)this).width;
        }
        return 0;
    }

    default public int getHeight() {
        if (this instanceof ContainerScreen) {
            return ((ContainerScreen)this).height;
        }
        return 0;
    }

    public void drawRect(int var1, int var2, int var3, int var4, int var5, int var6);

    public void drawRectFromIcon(int var1, int var2, TextureAtlasSprite var3, int var4, int var5);

    public FontRenderer getFont();

    public int getStringWidth(ITextComponent var1);

    public int getStringWidth(String var1);

    public int drawString(ITextComponent var1, int var2, int var3, int var4);

    public int drawString(String var1, int var2, int var3, int var4);

    public void drawCenteredText(ITextComponent var1, int var2, int var3, int var4);

    public void drawCenteredText(ITextComponent var1, int var2, int var3, int var4, int var5);

    public void renderScaledText(ITextComponent var1, int var2, int var3, int var4, int var5);

    public void renderScaledText(String var1, int var2, int var3, int var4, int var5);

    public void bindTexture(ResourceLocation var1);
}

