/*
 * Decompiled with CFR 0.152.
 */
package com.maciej916.maessentials.common.command.impl.admin;

import com.maciej916.maessentials.common.command.BaseCommand;
import com.maciej916.maessentials.common.data.DataManager;
import com.maciej916.maessentials.common.lib.player.EssentialPlayer;
import com.maciej916.maessentials.common.lib.player.PlayerRestriction;
import com.maciej916.maessentials.common.util.TimeUtils;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.player.ServerPlayerEntity;

public class CheckCommand
extends BaseCommand {
    public CheckCommand(String command, int permissionLevel, boolean enabled) {
        super(command, permissionLevel, enabled);
    }

    @Override
    public LiteralArgumentBuilder<CommandSource> setExecution() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)this.builder.then(Commands.func_197057_a((String)"bans").executes(context -> this.bansCheck((CommandSource)context.getSource())))).then(Commands.func_197057_a((String)"mutes").executes(context -> this.mutesCheck((CommandSource)context.getSource())));
    }

    private int bansCheck(CommandSource source) throws CommandSyntaxException {
        ServerPlayerEntity player = source.func_197035_h();
        HashMap<UUID, EssentialPlayer> players = DataManager.getPlayers();
        ArrayList<PlayerRestriction> restrictions = new ArrayList<PlayerRestriction>();
        for (Map.Entry<UUID, EssentialPlayer> entry : players.entrySet()) {
            EssentialPlayer eslPlayer = entry.getValue();
            PlayerRestriction restriction = eslPlayer.getRestrictions().getBan();
            if (!eslPlayer.getRestrictions().isRestricted(restriction)) continue;
            String display = eslPlayer.getUsername() == null ? "-" : eslPlayer.getUsername();
            restrictions.add(new PlayerRestriction(display, eslPlayer.getPlayerUUID(), restriction));
        }
        if (restrictions.size() > 0) {
            this.sendMessage(player, "check.maessentials.player.banned.list", new Object[0]);
            for (PlayerRestriction restriction : restrictions) {
                if (restriction.getTime() == -1L) {
                    this.sendMessage(player, "check.maessentials.player.banned.perm", restriction.getUsername(), restriction.getPlayerUUID(), restriction.getReason());
                    continue;
                }
                String displayTime = TimeUtils.formatDate(restriction.getTime() - TimeUtils.currentTimestamp());
                this.sendMessage(player, "check.maessentials.player.banned", restriction.getUsername(), restriction.getPlayerUUID(), displayTime, restriction.getReason());
            }
        } else {
            this.sendMessage(player, "check.maessentials.player.banned.empty", new Object[0]);
        }
        return 1;
    }

    private int mutesCheck(CommandSource source) throws CommandSyntaxException {
        ServerPlayerEntity player = source.func_197035_h();
        HashMap<UUID, EssentialPlayer> players = DataManager.getPlayers();
        ArrayList<PlayerRestriction> restrictions = new ArrayList<PlayerRestriction>();
        for (Map.Entry<UUID, EssentialPlayer> entry : players.entrySet()) {
            EssentialPlayer eslPlayer = entry.getValue();
            PlayerRestriction restriction = eslPlayer.getRestrictions().getMute();
            if (!eslPlayer.getRestrictions().isRestricted(restriction)) continue;
            String display = eslPlayer.getUsername() == null ? "-" : eslPlayer.getUsername();
            restrictions.add(new PlayerRestriction(display, eslPlayer.getPlayerUUID(), restriction));
        }
        if (restrictions.size() > 0) {
            this.sendMessage(player, "check.maessentials.player.muted.list", new Object[0]);
            for (PlayerRestriction restriction : restrictions) {
                if (restriction.getTime() == -1L) {
                    this.sendMessage(player, "check.maessentials.player.muted.perm", restriction.getUsername(), restriction.getPlayerUUID(), restriction.getReason());
                    continue;
                }
                String displayTime = TimeUtils.formatDate(restriction.getTime() - TimeUtils.currentTimestamp());
                this.sendMessage(player, "check.maessentials.player.muted", restriction.getUsername(), restriction.getPlayerUUID(), displayTime, restriction.getReason());
            }
        } else {
            this.sendMessage(player, "check.maessentials.player.muted.empty", new Object[0]);
        }
        return 1;
    }
}

